/**
 * Copyright (c) 2010-2012, Abel Hegedus, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.incquery.querybasedfeatures.tooling;

import com.google.common.base.Objects;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureKind;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class DerivedFeatureSourceCodeUtil {
  public CharSequence methodBody(final GenClass source, final GenFeature feature, final Pattern pattern, final String sourceParamName, final String targetParamName, final QueryBasedFeatureKind kind, final boolean keepCache) {
    CharSequence _switchResult = null;
    boolean _matched = false;
    if (!_matched) {
      if (Objects.equal(kind,QueryBasedFeatureKind.SINGLE_REFERENCE)) {
        _matched=true;
        CharSequence _singleRefGetMethod = this.singleRefGetMethod(source, feature, pattern, sourceParamName, targetParamName, keepCache);
        _switchResult = _singleRefGetMethod;
      }
    }
    if (!_matched) {
      if (Objects.equal(kind,QueryBasedFeatureKind.MANY_REFERENCE)) {
        _matched=true;
        CharSequence _manyRefGetMethod = this.manyRefGetMethod(source, feature, pattern, sourceParamName, targetParamName, keepCache);
        _switchResult = _manyRefGetMethod;
      }
    }
    if (!_matched) {
      if (Objects.equal(kind,QueryBasedFeatureKind.COUNTER)) {
        _matched=true;
        CharSequence _counterGetMethod = this.counterGetMethod(source, feature, pattern, sourceParamName, targetParamName);
        _switchResult = _counterGetMethod;
      }
    }
    if (!_matched) {
      if (Objects.equal(kind,QueryBasedFeatureKind.SUM)) {
        _matched=true;
        CharSequence _sumGetMethod = this.sumGetMethod(source, feature, pattern, sourceParamName, targetParamName);
        _switchResult = _sumGetMethod;
      }
    }
    if (!_matched) {
      if (Objects.equal(kind,QueryBasedFeatureKind.ITERATION)) {
        _matched=true;
        CharSequence _iterationGetMethod = this.iterationGetMethod(source, feature, pattern, sourceParamName, targetParamName);
        _switchResult = _iterationGetMethod;
      }
    }
    return _switchResult;
  }
  
  public CharSequence dummyCompUnitHeader() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("import org.eclipse.emf.common.util.EList;");
    _builder.newLine();
    _builder.append("import org.eclipse.emf.ecore.EClass;");
    _builder.newLine();
    _builder.append("import org.eclipse.incquery.querybasedfeatures.runtime.IQueryBasedFeatureHandler;");
    _builder.newLine();
    _builder.append("import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureKind;");
    _builder.newLine();
    _builder.append("import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureHelper;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public class DummyClass {");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("public void DummyMethod() {");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence singleRefGetMethod(final GenClass source, final GenFeature feature, final Pattern pattern, final String sourceParamName, final String targetParamName, final boolean keepCache) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _dummyCompUnitHeader = this.dummyCompUnitHeader();
    _builder.append(_dummyCompUnitHeader, "");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (");
    String _name = feature.getName();
    _builder.append(_name, "		");
    _builder.append("Handler == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    String _name_1 = feature.getName();
    _builder.append(_name_1, "			");
    _builder.append("Handler = QueryBasedFeatureHelper.getQueryBasedFeatureHandler(this,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    GenPackage _genPackage = source.getGenPackage();
    String _packageClassName = _genPackage.getPackageClassName();
    _builder.append(_packageClassName, "				");
    _builder.append(".Literals.");
    String _featureID = source.getFeatureID(feature);
    _builder.append(_featureID, "				");
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("\"");
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    _builder.append(_fullyQualifiedName, "				");
    _builder.append("\", \"");
    _builder.append(sourceParamName, "				");
    _builder.append("\", \"");
    _builder.append(targetParamName, "				");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("QueryBasedFeatureKind.SINGLE_REFERENCE,");
    _builder.append(keepCache, "				");
    _builder.append(", false);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return (");
    String _type = feature.getType(source);
    _builder.append(_type, "		");
    _builder.append(") ");
    String _name_2 = feature.getName();
    _builder.append(_name_2, "		");
    _builder.append("Handler.getSingleReferenceValue(this);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * if («feature.name»Handler != null) {
   * return («feature.getType(source)») «feature.name»Handler.getSingleReferenceValue();
   * } else {
   * «feature.name»Handler = IncqueryFeatureHelper.createHandler(this,
   * «source.genPackage.packageClassName».Literals.«source.getFeatureID(feature)»,
   * "«pattern.fullyQualifiedName»", "«sourceParamName»", "«targetParamName»",
   * FeatureKind.SINGLE_REFERENCE,«keepCache»);
   * if («feature.name»Handler != null) {
   * return («feature.getType(source)») «feature.name»Handler.getSingleReferenceValue();
   * }
   * }
   * return null;
   */
  public CharSequence manyRefGetMethod(final GenClass source, final GenFeature feature, final Pattern pattern, final String sourceParamName, final String targetParamName, final boolean keepCache) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _dummyCompUnitHeader = this.dummyCompUnitHeader();
    _builder.append(_dummyCompUnitHeader, "");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if(");
    String _name = feature.getName();
    _builder.append(_name, "		");
    _builder.append("Handler == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    String _name_1 = feature.getName();
    _builder.append(_name_1, "			");
    _builder.append("Handler = QueryBasedFeatureHelper.getQueryBasedFeatureHandler(this,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    GenPackage _genPackage = source.getGenPackage();
    String _packageClassName = _genPackage.getPackageClassName();
    _builder.append(_packageClassName, "				");
    _builder.append(".Literals.");
    String _featureID = source.getFeatureID(feature);
    _builder.append(_featureID, "				");
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("\"");
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    _builder.append(_fullyQualifiedName, "				");
    _builder.append("\", \"");
    _builder.append(sourceParamName, "				");
    _builder.append("\", \"");
    _builder.append(targetParamName, "				");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("QueryBasedFeatureKind.MANY_REFERENCE,");
    _builder.append(keepCache, "				");
    _builder.append(", false);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    String _name_2 = feature.getName();
    _builder.append(_name_2, "		");
    _builder.append("Handler.getManyReferenceValueAsEList(this);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence counterGetMethod(final GenClass source, final GenFeature feature, final Pattern pattern, final String sourceParamName, final String targetParamName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _dummyCompUnitHeader = this.dummyCompUnitHeader();
    _builder.append(_dummyCompUnitHeader, "");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (");
    String _name = feature.getName();
    _builder.append(_name, "		");
    _builder.append("Handler == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    String _name_1 = feature.getName();
    _builder.append(_name_1, "			");
    _builder.append("Handler = QueryBasedFeatureHelper.getQueryBasedFeatureHandler(this,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    GenPackage _genPackage = source.getGenPackage();
    String _packageClassName = _genPackage.getPackageClassName();
    _builder.append(_packageClassName, "				");
    _builder.append(".Literals.");
    String _featureID = source.getFeatureID(feature);
    _builder.append(_featureID, "				");
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("\"");
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    _builder.append(_fullyQualifiedName, "				");
    _builder.append("\", \"");
    _builder.append(sourceParamName, "				");
    _builder.append("\", null,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("QueryBasedFeatureKind.COUNTER, true, false);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    String _name_2 = feature.getName();
    _builder.append(_name_2, "		");
    _builder.append("Handler.getIntValue(this);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence sumGetMethod(final GenClass source, final GenFeature feature, final Pattern pattern, final String sourceParamName, final String targetParamName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _dummyCompUnitHeader = this.dummyCompUnitHeader();
    _builder.append(_dummyCompUnitHeader, "");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (");
    String _name = feature.getName();
    _builder.append(_name, "		");
    _builder.append("Handler == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    String _name_1 = feature.getName();
    _builder.append(_name_1, "			");
    _builder.append("Handler = QueryBasedFeatureHelper.getQueryBasedFeatureHandler(this,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    GenPackage _genPackage = source.getGenPackage();
    String _packageClassName = _genPackage.getPackageClassName();
    _builder.append(_packageClassName, "				");
    _builder.append(".Literals.");
    String _featureID = source.getFeatureID(feature);
    _builder.append(_featureID, "				");
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("\"");
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    _builder.append(_fullyQualifiedName, "				");
    _builder.append("\", \"");
    _builder.append(sourceParamName, "				");
    _builder.append("\", \"");
    _builder.append(targetParamName, "				");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("QueryBasedFeatureKind.SUM, true, false);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    String _name_2 = feature.getName();
    _builder.append(_name_2, "		");
    _builder.append("Handler.getIntValue(this);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence iterationGetMethod(final GenClass source, final GenFeature feature, final Pattern pattern, final String sourceParamName, final String targetParamName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _dummyCompUnitHeader = this.dummyCompUnitHeader();
    _builder.append(_dummyCompUnitHeader, "");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (");
    String _name = feature.getName();
    _builder.append(_name, "		");
    _builder.append("Handler == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    String _name_1 = feature.getName();
    _builder.append(_name_1, "			");
    _builder.append("Handler = QueryBasedFeatureHelper.getQueryBasedFeatureHandler(this,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    GenPackage _genPackage = source.getGenPackage();
    String _packageClassName = _genPackage.getPackageClassName();
    _builder.append(_packageClassName, "				");
    _builder.append(".Literals.");
    String _featureID = source.getFeatureID(feature);
    _builder.append(_featureID, "				");
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("\"");
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    _builder.append(_fullyQualifiedName, "				");
    _builder.append("\", \"");
    _builder.append(sourceParamName, "				");
    _builder.append("\", \"");
    _builder.append(targetParamName, "				");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("QueryBasedFeatureKind.ITERATION, true, false);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return (");
    String _type = feature.getType(source);
    _builder.append(_type, "		");
    _builder.append(") ");
    String _name_2 = feature.getName();
    _builder.append(_name_2, "		");
    _builder.append("Handler.getValueIteration(this);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence singleRefSetMethod(final GenFeature feature, final Pattern pattern, final String parameter, final String setMethod, final String setExpression) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _dummyCompUnitHeader = this.dummyCompUnitHeader();
    _builder.append(_dummyCompUnitHeader, "");
    _builder.newLineIfNotEmpty();
    _builder.append("    ");
    _builder.append("if(");
    _builder.append(parameter, "    ");
    _builder.append(" != null){");
    _builder.newLineIfNotEmpty();
    _builder.append("      ");
    _builder.append(setMethod, "      ");
    _builder.append("(");
    _builder.append(setExpression, "      ");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("    ");
    _builder.append("}  else {");
    _builder.newLine();
    _builder.append("      ");
    _builder.append(setMethod, "      ");
    _builder.append("(null);");
    _builder.newLineIfNotEmpty();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence defaultMethod(final boolean manyFeature) {
    CharSequence _xifexpression = null;
    if (manyFeature) {
      CharSequence _defaultListGetMethod = this.defaultListGetMethod();
      _xifexpression = _defaultListGetMethod;
    } else {
      CharSequence _defaultSingleGetMethod = this.defaultSingleGetMethod();
      _xifexpression = _defaultSingleGetMethod;
    }
    return _xifexpression;
  }
  
  public CharSequence defaultSingleGetMethod() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("import java.lang.UnsupportedOperationException;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public class DummyClass {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void DummyMethod() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// TODO: implement this method to return the \'X\' reference");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// -> do not perform proxy resolution");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// Ensure that you remove @generated or mark it @generated NOT");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("throw new UnsupportedOperationException();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence defaultListGetMethod() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("import java.lang.UnsupportedOperationException;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public class DummyClass {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void DummyMethod() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// TODO: implement this method to return the \'X\' reference list");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// Ensure that you remove @generated or mark it @generated NOT");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// The list is expected to implement org.eclipse.emf.ecore.util.InternalEList and org.eclipse.emf.ecore.EStructuralFeature.Setting");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// so it\'s likely that an appropriate subclass of org.eclipse.emf.ecore.util.EcoreEList should be used.");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("throw new UnsupportedOperationException();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
