/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.itc.alg.incscc;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.base.itc.alg.counting.CountingAlg;
import org.eclipse.incquery.runtime.base.itc.alg.dred.DRedTcRelation;
import org.eclipse.incquery.runtime.base.itc.alg.incscc.CollectionHelper;
import org.eclipse.incquery.runtime.base.itc.alg.incscc.CountingListener;
import org.eclipse.incquery.runtime.base.itc.alg.incscc.Direction;
import org.eclipse.incquery.runtime.base.itc.alg.incscc.UnionFind;
import org.eclipse.incquery.runtime.base.itc.alg.misc.GraphHelper;
import org.eclipse.incquery.runtime.base.itc.alg.misc.Tuple;
import org.eclipse.incquery.runtime.base.itc.alg.misc.bfs.BFS;
import org.eclipse.incquery.runtime.base.itc.alg.misc.scc.SCC;
import org.eclipse.incquery.runtime.base.itc.alg.misc.scc.SCCResult;
import org.eclipse.incquery.runtime.base.itc.graphimpl.Graph;
import org.eclipse.incquery.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;
import org.eclipse.incquery.runtime.base.itc.igraph.IBiDirectionalWrapper;
import org.eclipse.incquery.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.incquery.runtime.base.itc.igraph.IGraphObserver;
import org.eclipse.incquery.runtime.base.itc.igraph.ITcDataSource;
import org.eclipse.incquery.runtime.base.itc.igraph.ITcObserver;

public class IncSCCAlg<V>
implements IGraphObserver<V>,
ITcDataSource<V> {
    private static final long serialVersionUID = 6207002106223444807L;
    public UnionFind<V> sccs;
    public IBiDirectionalGraphDataSource<V> gds;
    private CountingAlg<V> counting;
    private Graph<V> reducedGraph;
    private IBiDirectionalGraphDataSource<V> reducedGraphIndexer;
    private List<ITcObserver<V>> observers;
    private CountingListener<V> countingListener;

    public IncSCCAlg(IGraphDataSource<V> graphDataSource) {
        this.gds = graphDataSource instanceof IBiDirectionalGraphDataSource ? (IBiDirectionalGraphDataSource)graphDataSource : new IBiDirectionalWrapper<V>(graphDataSource);
        this.observers = new ArrayList<ITcObserver<V>>();
        this.sccs = new UnionFind();
        this.reducedGraph = new Graph();
        this.reducedGraphIndexer = new IBiDirectionalWrapper<V>(this.reducedGraph);
        this.countingListener = new CountingListener(this);
        this.initalizeInternalDataStructures();
        this.gds.attachObserver(this);
    }

    private void initalizeInternalDataStructures() {
        SCCResult<V> _sccres = SCC.computeSCC(this.gds);
        Set<Set<V>> _sccs = _sccres.getSccs();
        for (Set<V> _set : _sccs) {
            this.sccs.makeSet(_set);
        }
        for (Object n : this.sccs.setMap.keySet()) {
            this.reducedGraph.insertNode(n);
        }
        for (Object source : this.gds.getAllNodes()) {
            List<Object> targetNodes = this.gds.getTargetNodes(source);
            if (targetNodes == null) continue;
            for (Object target : targetNodes) {
                Object targetRoot;
                Object sourceRoot = this.sccs.find(source);
                if (sourceRoot.equals(targetRoot = this.sccs.find(target))) continue;
                this.reducedGraph.insertEdge(sourceRoot, targetRoot);
            }
        }
        this.counting = new CountingAlg<V>(this.reducedGraph);
    }

    @Override
    public void edgeInserted(V source, V target) {
        V targetRoot;
        V sourceRoot = this.sccs.find(source);
        if (!sourceRoot.equals(targetRoot = this.sccs.find(target))) {
            if (this.counting.isReachable(targetRoot, sourceRoot)) {
                AbstractCollection targetSCCs;
                AbstractCollection sourceSCCs;
                Set<V> predecessorRoots = this.counting.getAllReachableSources(sourceRoot);
                Set<V> successorRoots = this.counting.getAllReachableTargets(targetRoot);
                Set<V> isectRoots = CollectionHelper.intersection(predecessorRoots, successorRoots);
                isectRoots.add(sourceRoot);
                isectRoots.add(targetRoot);
                if (this.observers.size() > 0) {
                    sourceSCCs = new HashSet();
                    targetSCCs = new HashSet();
                    sourceSCCs.add(sourceRoot);
                    sourceSCCs.addAll(predecessorRoots);
                    targetSCCs.add(targetRoot);
                    targetSCCs.addAll(successorRoots);
                    for (Object sourceSCC : sourceSCCs) {
                        for (Object targetSCC : CollectionHelper.difference(targetSCCs, this.counting.getAllReachableTargets(sourceSCC))) {
                            boolean needsNotification = false;
                            if (sourceSCC.equals(targetSCC) && this.sccs.setMap.get(sourceSCC).size() == 1 && GraphHelper.getEdgeCount(this.sccs.setMap.get(sourceSCC).iterator().next(), this.gds) == 0) {
                                needsNotification = true;
                            } else if (!sourceSCC.equals(targetSCC)) {
                                needsNotification = true;
                            }
                            if (!needsNotification) continue;
                            this.notifyTcObservers((V)this.sccs.setMap.get(sourceSCC), (V)this.sccs.setMap.get(targetSCC), Direction.INSERT);
                        }
                    }
                }
                sourceSCCs = new ArrayList();
                targetSCCs = new ArrayList();
                for (V r : isectRoots) {
                    List<V> sourceSCCsOfSCC = this.getSourceSCCsOfSCC(r);
                    List<V> targetSCCsOfSCC = this.getTargetSCCsOfSCC(r);
                    for (V sourceSCC : sourceSCCsOfSCC) {
                        if (sourceSCC.equals(r)) continue;
                        this.reducedGraph.deleteEdge(sourceSCC, r);
                    }
                    for (V targetSCC : targetSCCsOfSCC) {
                        if (isectRoots.contains(targetSCC) || r.equals(targetSCC)) continue;
                        this.reducedGraph.deleteEdge(r, targetSCC);
                    }
                    sourceSCCs.addAll(sourceSCCsOfSCC);
                    targetSCCs.addAll(targetSCCsOfSCC);
                }
                for (V r : isectRoots) {
                    this.reducedGraph.deleteNode(r);
                }
                Iterator<V> iterator = isectRoots.iterator();
                V newRoot = iterator.next();
                while (iterator.hasNext()) {
                    newRoot = this.sccs.union(newRoot, iterator.next());
                }
                this.reducedGraph.insertNode(newRoot);
                Set containedNodes = this.sccs.setMap.get(newRoot);
                for (Object sourceSCC : sourceSCCs) {
                    if (containedNodes.contains(sourceSCC) || sourceSCC.equals(newRoot)) continue;
                    this.reducedGraph.insertEdge(sourceSCC, newRoot);
                }
                for (Object targetSCC : targetSCCs) {
                    if (containedNodes.contains(targetSCC) || targetSCC.equals(newRoot)) continue;
                    this.reducedGraph.insertEdge(newRoot, targetSCC);
                }
            } else {
                if (this.observers.size() > 0 && GraphHelper.getEdgeCount(source, target, this.gds) == 1) {
                    this.counting.attachObserver(this.countingListener);
                }
                this.reducedGraph.insertEdge(sourceRoot, targetRoot);
                this.counting.detachObserver(this.countingListener);
            }
        } else if (this.observers.size() > 0 && this.sccs.setMap.get(sourceRoot).size() == 1 && GraphHelper.getEdgeCount(source, target, this.gds) == 1) {
            this.notifyTcObservers(source, source, Direction.INSERT);
        }
    }

    @Override
    public void edgeDeleted(V source, V target) {
        V targetRoot;
        V sourceRoot = this.sccs.find(source);
        if (!sourceRoot.equals(targetRoot = this.sccs.find(target))) {
            if (this.observers.size() > 0 && GraphHelper.getEdgeCount(source, target, this.gds) == 0) {
                this.counting.attachObserver(this.countingListener);
            }
            this.reducedGraph.deleteEdge(sourceRoot, targetRoot);
            this.counting.detachObserver(this.countingListener);
        } else {
            Graph<V> g = GraphHelper.getSubGraph(this.sccs.setMap.get(sourceRoot), this.gds);
            if (!BFS.isReachable(source, target, g)) {
                ArrayList reachableSources = this.reducedGraphIndexer.getSourceNodes(sourceRoot) == null ? new ArrayList() : new ArrayList<V>(this.reducedGraphIndexer.getSourceNodes(sourceRoot));
                ArrayList reachableTargets = this.reducedGraphIndexer.getTargetNodes(sourceRoot) == null ? new ArrayList() : new ArrayList<V>(this.reducedGraphIndexer.getTargetNodes(sourceRoot));
                SCCResult<V> _newSccs = SCC.computeSCC(g);
                for (Object s : reachableSources) {
                    this.reducedGraph.deleteEdge(s, sourceRoot);
                }
                for (Object t : reachableTargets) {
                    this.reducedGraph.deleteEdge(sourceRoot, t);
                }
                this.sccs.deleteSet(sourceRoot);
                this.reducedGraph.deleteNode(sourceRoot);
                Set<Set<V>> newSCCs = _newSccs.getSccs();
                HashSet<Set<V>> newSCCRoots = new HashSet<Set<V>>();
                for (Set<V> set : newSCCs) {
                    Set<V> newRoot = this.sccs.makeSet(set);
                    this.reducedGraph.insertNode(newRoot);
                    newSCCRoots.add(newRoot);
                }
                for (Object object : newSCCRoots) {
                    List<Object> sourceSCCsOfSCC = this.getSourceSCCsOfSCC(object);
                    List<Object> targetSCCsOfSCC = this.getTargetSCCsOfSCC(object);
                    for (Object sourceSCC : sourceSCCsOfSCC) {
                        if (sourceSCC.equals(object)) continue;
                        this.reducedGraph.insertEdge(this.sccs.find(sourceSCC), object);
                    }
                    for (Object targetSCC : targetSCCsOfSCC) {
                        if (newSCCRoots.contains(targetSCC) || targetSCC.equals(object)) continue;
                        this.reducedGraph.insertEdge(object, targetSCC);
                    }
                }
                if (this.observers.size() > 0) {
                    V v = this.sccs.find(source);
                    V newTargetRoot = this.sccs.find(target);
                    Set<V> sourceSCCs = this.counting.getAllReachableSources(v);
                    sourceSCCs.add(v);
                    Set<V> targetSCCs = this.counting.getAllReachableTargets(newTargetRoot);
                    targetSCCs.add(newTargetRoot);
                    for (Object sourceSCC : sourceSCCs) {
                        for (Object targetSCC : CollectionHelper.difference(targetSCCs, this.counting.getAllReachableTargets(sourceSCC))) {
                            boolean needsNotification = false;
                            if (sourceSCC.equals(targetSCC) && this.sccs.setMap.get(sourceSCC).size() == 1 && GraphHelper.getEdgeCount(this.sccs.setMap.get(sourceSCC).iterator().next(), this.gds) == 0) {
                                needsNotification = true;
                            } else if (!sourceSCC.equals(targetSCC)) {
                                needsNotification = true;
                            }
                            if (!needsNotification) continue;
                            this.notifyTcObservers((V)this.sccs.setMap.get(sourceSCC), (V)this.sccs.setMap.get(targetSCC), Direction.DELETE);
                        }
                    }
                }
            } else if (this.observers.size() > 0 && this.sccs.setMap.get(sourceRoot).size() == 1 && GraphHelper.getEdgeCount(source, target, this.gds) == 0) {
                this.notifyTcObservers(source, source, Direction.DELETE);
            }
        }
    }

    @Override
    public void nodeInserted(V n) {
        this.sccs.makeSet(n);
        this.reducedGraph.insertNode(n);
    }

    @Override
    public void nodeDeleted(V n) {
        List<V> sources = this.gds.getSourceNodes(n);
        List<V> targets = this.gds.getTargetNodes(n);
        if (sources != null) {
            for (V source : sources) {
                this.edgeDeleted(source, n);
            }
        }
        if (targets != null) {
            for (V target : this.gds.getTargetNodes(n)) {
                this.edgeDeleted(n, target);
            }
        }
        this.sccs.deleteSet(n);
    }

    @Override
    public void attachObserver(ITcObserver<V> to) {
        this.observers.add(to);
    }

    @Override
    public void detachObserver(ITcObserver<V> to) {
        this.observers.remove(to);
    }

    @Override
    public Set<V> getAllReachableTargets(V source) {
        Set<V> rootSet;
        V sourceRoot = this.sccs.find(source);
        Set containedNodes = this.sccs.setMap.get(sourceRoot);
        HashSet targets = new HashSet();
        if (containedNodes.size() > 1 || GraphHelper.getEdgeCount(source, this.gds) == 1) {
            targets.addAll(containedNodes);
        }
        if ((rootSet = this.counting.getAllReachableTargets(sourceRoot)) != null) {
            for (V _root : rootSet) {
                targets.addAll(this.sccs.setMap.get(_root));
            }
        }
        return targets;
    }

    @Override
    public Set<V> getAllReachableSources(V target) {
        Set<V> rootSet;
        V targetRoot = this.sccs.find(target);
        Set containedNodes = this.sccs.setMap.get(targetRoot);
        HashSet sources = new HashSet();
        if (containedNodes.size() > 1 || GraphHelper.getEdgeCount(target, this.gds) == 1) {
            sources.addAll(containedNodes);
        }
        if ((rootSet = this.counting.getAllReachableSources(targetRoot)) != null) {
            for (V _root : rootSet) {
                sources.addAll(this.sccs.setMap.get(_root));
            }
        }
        return sources;
    }

    @Override
    public boolean isReachable(V source, V target) {
        V targetRoot;
        V sourceRoot = this.sccs.find(source);
        if (sourceRoot.equals(targetRoot = this.sccs.find(target))) {
            return true;
        }
        return this.counting.isReachable(sourceRoot, targetRoot);
    }

    @Override
    public List<V> getReachabilityPath(V source, V target) {
        if (!this.isReachable(source, target)) {
            return null;
        }
        Set<V> sccsInSubGraph = CollectionHelper.intersection(this.counting.getAllReachableTargets(source), this.counting.getAllReachableSources(target));
        sccsInSubGraph.add(this.sccs.find(source));
        sccsInSubGraph.add(this.sccs.find(target));
        HashSet nodesInSubGraph = new HashSet();
        for (V sccRoot : sccsInSubGraph) {
            nodesInSubGraph.addAll(this.sccs.setMap.get(sccRoot));
        }
        return GraphHelper.constructPath(source, target, nodesInSubGraph, this.gds);
    }

    public boolean checkTcRelation(DRedTcRelation<V> tc) {
        for (V s : tc.getTupleStarts()) {
            for (V t : tc.getTupleEnds(s)) {
                if (this.isReachable(s, t)) continue;
                return false;
            }
        }
        for (V root : this.counting.getTcRelation().getTupleStarts()) {
            for (V end : this.counting.getTcRelation().getTupleEnds(root)) {
                for (Object s : this.sccs.setMap.get(root)) {
                    for (Object t : this.sccs.setMap.get(end)) {
                        if (tc.containsTuple(s, t)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private List<V> getSourceSCCsOfSCC(V root) {
        ArrayList<V> sourceSCCs = new ArrayList<V>();
        for (Object containedNode : this.sccs.setMap.get(root)) {
            List<V> sourceNodes = this.gds.getSourceNodes(containedNode);
            if (sourceNodes == null) continue;
            for (V source : sourceNodes) {
                sourceSCCs.add(this.sccs.find(source));
            }
        }
        return sourceSCCs;
    }

    private List<V> getTargetSCCsOfSCC(V root) {
        ArrayList<V> targetSCCs = new ArrayList<V>();
        for (Object containedNode : this.sccs.setMap.get(root)) {
            List targetNodes = this.gds.getTargetNodes(containedNode);
            if (targetNodes == null) continue;
            for (Object target : targetNodes) {
                targetSCCs.add(this.sccs.find(target));
            }
        }
        return targetSCCs;
    }

    @Override
    public void dispose() {
        this.gds.detachObserver(this);
        this.counting.dispose();
    }

    protected void notifyTcObservers(Set<V> sources, Set<V> targets, Direction direction) {
        for (V s : sources) {
            for (V t : targets) {
                this.notifyTcObservers(s, t, direction);
            }
        }
    }

    private void notifyTcObservers(V source, V target, Direction direction) {
        for (ITcObserver<V> observer : this.observers) {
            if (direction == Direction.INSERT) {
                observer.tupleInserted(source, target);
            }
            if (direction != Direction.DELETE) continue;
            observer.tupleDeleted(source, target);
        }
    }

    public Set<Tuple<V>> getTcRelation() {
        HashSet<Tuple<V>> resultSet = new HashSet<Tuple<V>>();
        for (Object sourceRoot : this.sccs.setMap.keySet()) {
            Set<V> reachableTargets;
            Set sources = this.sccs.setMap.get(sourceRoot);
            if (sources.size() > 1 || GraphHelper.getEdgeCount(sources.iterator().next(), this.gds) == 1) {
                for (Object source : sources) {
                    for (Object target : sources) {
                        resultSet.add(new Tuple(source, target));
                    }
                }
            }
            if ((reachableTargets = this.counting.getAllReachableTargets(sourceRoot)) == null) continue;
            for (V targetRoot : reachableTargets) {
                for (Object source : sources) {
                    for (Object target : this.sccs.setMap.get(targetRoot)) {
                        resultSet.add(new Tuple(source, target));
                    }
                }
            }
        }
        return resultSet;
    }

    public boolean isIsolated(V node) {
        List<V> targets = this.gds.getTargetNodes(node);
        List<V> sources = this.gds.getSourceNodes(node);
        return !(targets != null && !targets.isEmpty() || sources != null && !sources.isEmpty());
    }
}

