/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.basicenumerables;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.IPatternMatcherContext;
import org.eclipse.incquery.runtime.matchers.psystem.ITypeInfoProviderConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;

public class TypeTernary
extends TypeConstraint
implements ITypeInfoProviderConstraint {
    private final IPatternMatcherContext context;
    private PVariable edge;
    private PVariable source;
    private PVariable target;

    public TypeTernary(PBody pSystem, IPatternMatcherContext context, PVariable edge, PVariable source, PVariable target, Object supplierKey, String typeString) {
        super(pSystem, new FlatTuple(edge, source, target), supplierKey, typeString);
        this.edge = edge;
        this.source = source;
        this.target = target;
        this.context = context;
    }

    @Override
    public Object getTypeInfo(PVariable variable) {
        if (variable.equals(this.variablesTuple.get(0))) {
            return ITypeInfoProviderConstraint.TypeInfoSpecials.wrapTernary(this.supplierKey);
        }
        if (variable.equals(this.variablesTuple.get(1))) {
            return ITypeInfoProviderConstraint.TypeInfoSpecials.wrapAny(this.context.ternaryEdgeSourceType(this.supplierKey));
        }
        if (variable.equals(this.variablesTuple.get(2))) {
            return ITypeInfoProviderConstraint.TypeInfoSpecials.wrapAny(this.context.ternaryEdgeTargetType(this.supplierKey));
        }
        return ITypeInfoProviderConstraint.TypeInfoSpecials.NO_TYPE_INFO_PROVIDED;
    }

    @Override
    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies() {
        HashMap<Set<PVariable>, Set<PVariable>> result = new HashMap<Set<PVariable>, Set<PVariable>>();
        result.put(Collections.singleton(this.edge), new HashSet<PVariable>(Arrays.asList(this.source, this.target)));
        if (this.context.isBinaryEdgeMultiplicityToOne(this.supplierKey)) {
            result.put(Collections.singleton(this.source), new HashSet<PVariable>(Arrays.asList(this.edge, this.target)));
        }
        if (this.context.isBinaryEdgeMultiplicityOneTo(this.supplierKey)) {
            result.put(Collections.singleton(this.target), new HashSet<PVariable>(Arrays.asList(this.source, this.edge)));
        }
        return result;
    }
}

