/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.basicdeferred;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.VariableDeferredPConstraint;

public class Inequality
extends VariableDeferredPConstraint {
    private PVariable who;
    private PVariable withWhom;
    private boolean weak;

    public Inequality(PBody pSystem, PVariable who, PVariable withWhom) {
        this(pSystem, who, withWhom, false);
    }

    public Inequality(PBody pSystem, PVariable who, PVariable withWhom, boolean weak) {
        super(pSystem, new HashSet<PVariable>(Arrays.asList(who, withWhom)));
        this.who = who;
        this.withWhom = withWhom;
        this.weak = weak;
    }

    @Override
    public Set<PVariable> getDeferringVariables() {
        return this.getAffectedVariables();
    }

    @Override
    protected String toStringRest() {
        return String.valueOf(this.who.toString()) + (this.isWeak() ? "!=?" : "!=") + this.withWhom.toString();
    }

    @Override
    public void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        if (obsolete.equals(this.who)) {
            this.who = replacement;
        }
        if (obsolete.equals(this.withWhom)) {
            this.withWhom = replacement;
        }
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        return Collections.emptySet();
    }

    public boolean isWeak() {
        return this.weak;
    }

    public boolean isEliminable() {
        return this.isWeak() && (this.who.equals(this.withWhom) || !this.who.isDeducable() || !this.withWhom.isDeducable());
    }

    public void eliminateWeak() {
        if (this.isEliminable()) {
            this.delete();
        }
    }

    public PVariable getWho() {
        return this.who;
    }

    public PVariable getWithWhom() {
        return this.withWhom;
    }
}

