/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.databinding.runtime.adapter.DatabindingAdapterUtil;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.impl.StringValueImpl;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.IncQueryModelUpdateListener;
import org.eclipse.incquery.runtime.rete.misc.DeltaMonitor;
import org.eclipse.incquery.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatch;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatcherRoot;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.DisplayUtil;
import org.eclipse.swt.widgets.Display;

public class ObservablePatternMatcher {
    private static final String KEY_ATTRIBUTE_COMPARABLE_INTERFACE = "The key attribute does not implement the Comparable interface!";
    private static final String KEY_ATTRIBUTE_OF_ORDER_BY_ANNOTATION = "The key attribute of OrderBy annotation must look like \"ClassName.AttributeName\"!";
    private final List<ObservablePatternMatch> matches;
    private final IncQueryMatcher<IPatternMatch> matcher;
    private DeltaMonitor<IPatternMatch> deltaMonitor;
    private Runnable processMatchesRunnable;
    private Map<IPatternMatch, ObservablePatternMatch> sigMap;
    private final ObservablePatternMatcherRoot parent;
    private final boolean generated;
    private final String patternFqn;
    private IPatternMatch filter;
    private Object[] parameterFilter;
    private String orderParameter;
    private boolean descendingOrder;
    private final String exceptionMessage;
    private IncQueryModelUpdateListener modelUpdateListener;
    public static final String MATCHES_ID = "matches";

    public ObservablePatternMatcher(ObservablePatternMatcherRoot parent, IncQueryMatcher<IPatternMatch> matcher, String patternFqn, boolean generated, String exceptionMessage) {
        this.parent = parent;
        this.patternFqn = patternFqn;
        this.matches = new ArrayList<ObservablePatternMatch>();
        this.matcher = matcher;
        this.generated = generated;
        this.orderParameter = null;
        this.exceptionMessage = exceptionMessage;
        DisplayUtil.removeOrderByPatternWarning(patternFqn);
        if (matcher != null) {
            this.initOrdering();
            this.initFilter();
            this.sigMap = new HashMap<IPatternMatch, ObservablePatternMatch>();
            this.deltaMonitor = this.matcher.newFilteredDeltaMonitor(true, this.filter);
            this.processMatchesRunnable = new Runnable(){

                @Override
                public void run() {
                    if (((ObservablePatternMatcher)ObservablePatternMatcher.this).deltaMonitor.matchFoundEvents.size() > 0 || ((ObservablePatternMatcher)ObservablePatternMatcher.this).deltaMonitor.matchLostEvents.size() > 0) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ObservablePatternMatcher.this.processNewMatches(((ObservablePatternMatcher)(this).ObservablePatternMatcher.this).deltaMonitor.matchFoundEvents);
                                ObservablePatternMatcher.this.processLostMatches(((ObservablePatternMatcher)(this).ObservablePatternMatcher.this).deltaMonitor.matchLostEvents);
                                ObservablePatternMatcher.this.deltaMonitor.clear();
                            }
                        });
                    }
                }
            };
            this.modelUpdateListener = new IncQueryModelUpdateListener(){

                public void notifyChanged(IncQueryModelUpdateListener.ChangeLevel changeLevel) {
                    ObservablePatternMatcher.this.processMatchesRunnable.run();
                }

                public IncQueryModelUpdateListener.ChangeLevel getLevel() {
                    return IncQueryModelUpdateListener.ChangeLevel.MATCHSET;
                }
            };
            parent.getKey().getEngine().addModelUpdateListener(this.modelUpdateListener);
            this.processMatchesRunnable.run();
        }
    }

    private void initOrdering() {
        Annotation annotation = CorePatternLanguageHelper.getFirstAnnotationByName((Pattern)this.matcher.getPattern(), (String)"OrderBy");
        if (annotation != null) {
            for (AnnotationParameter ap : annotation.getParameters()) {
                if (ap.getName().matches("key")) {
                    this.orderParameter = ((StringValueImpl)ap.getValue()).getValue();
                }
                if (!ap.getName().matches("direction")) continue;
                String direction = ((StringValueImpl)ap.getValue()).getValue();
                this.descendingOrder = direction.matches("desc");
            }
        }
    }

    public void dispose() {
        if (this.matcher != null) {
            for (ObservablePatternMatch pm : this.matches) {
                pm.dispose();
            }
            this.parent.getKey().getEngine().removeModelUpdateListener(this.modelUpdateListener);
            this.processMatchesRunnable = null;
        }
    }

    private int placeOfMatch(IPatternMatch match) {
        if (this.orderParameter != null) {
            String[] tokens = this.orderParameter.split("\\.");
            if (tokens.length == 2) {
                EStructuralFeature feature;
                String orderParameterClass = tokens[0];
                String orderParameterAttribute = tokens[1];
                EObject obj = (EObject)match.get(orderParameterClass);
                Object value = obj.eGet(feature = DatabindingAdapterUtil.getFeature((Object)obj, (String)orderParameterAttribute));
                if (value instanceof Comparable) {
                    int i = 0;
                    while (i < this.matches.size()) {
                        IPatternMatch compMatch = this.matches.get(i).getPatternMatch();
                        EObject compObj = (EObject)compMatch.get(orderParameterClass);
                        EStructuralFeature compFeature = DatabindingAdapterUtil.getFeature((Object)compObj, (String)orderParameterAttribute);
                        Comparable compValue = (Comparable)compObj.eGet(compFeature);
                        if (this.descendingOrder ? compValue.compareTo(value) <= 0 : compValue.compareTo(value) >= 0) {
                            return i;
                        }
                        ++i;
                    }
                } else {
                    DisplayUtil.addOrderByPatternWarning(CorePatternLanguageHelper.getFullyQualifiedName((Pattern)this.matcher.getPattern()), KEY_ATTRIBUTE_COMPARABLE_INTERFACE);
                }
            } else {
                DisplayUtil.addOrderByPatternWarning(CorePatternLanguageHelper.getFullyQualifiedName((Pattern)this.matcher.getPattern()), KEY_ATTRIBUTE_OF_ORDER_BY_ANNOTATION);
            }
        }
        return -1;
    }

    private void processNewMatches(Collection<IPatternMatch> matches) {
        for (IPatternMatch s : matches) {
            this.addMatch(s);
        }
    }

    private void processLostMatches(Collection<IPatternMatch> matches) {
        for (IPatternMatch s : matches) {
            this.removeMatch(s);
        }
    }

    private void addMatch(IPatternMatch match) {
        ObservablePatternMatch pm = new ObservablePatternMatch(this, match);
        this.sigMap.put(match, pm);
        int index = this.placeOfMatch(match);
        if (index == -1) {
            this.matches.add(pm);
        } else {
            this.matches.add(index, pm);
        }
        if (QueryExplorer.getInstance() != null) {
            QueryExplorer.getInstance().getMatcherTreeViewer().refresh((Object)this);
        }
    }

    private void removeMatch(IPatternMatch match) {
        ObservablePatternMatch observableMatch = this.sigMap.remove(match);
        if (observableMatch != null) {
            this.matches.remove(observableMatch);
            observableMatch.dispose();
        }
        if (QueryExplorer.getInstance() != null) {
            QueryExplorer.getInstance().getMatcherTreeViewer().refresh((Object)this);
        }
    }

    public ObservablePatternMatcherRoot getParent() {
        return this.parent;
    }

    public IncQueryMatcher<IPatternMatch> getMatcher() {
        return this.matcher;
    }

    public String getPatternName() {
        return this.patternFqn;
    }

    private void initFilter() {
        if (this.matcher != null) {
            int arity = this.matcher.getParameterNames().size();
            this.parameterFilter = new Object[arity];
            this.filter = this.matcher.newMatch(this.parameterFilter);
        }
    }

    public void setFilter(Object[] parameterFilter) {
        this.parameterFilter = (Object[])parameterFilter.clone();
        this.filter = this.matcher.newMatch(this.parameterFilter);
        HashSet<IPatternMatch> tmp = new HashSet<IPatternMatch>(this.sigMap.keySet());
        for (IPatternMatch match : tmp) {
            this.removeMatch(match);
        }
        if (QueryExplorer.getInstance() != null) {
            QueryExplorer.getInstance().getMatcherTreeViewer().refresh((Object)this);
        }
        this.deltaMonitor = this.matcher.newFilteredDeltaMonitor(true, this.filter);
        this.processMatchesRunnable.run();
    }

    private boolean isFiltered() {
        if (this.matcher != null) {
            int i = 0;
            while (i < this.matcher.getParameterNames().size()) {
                if (this.parameterFilter[i] != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Object[] getFilter() {
        return this.parameterFilter;
    }

    public String getText() {
        return DisplayUtil.getMessage(this.matcher, this.matches.size(), this.patternFqn, this.isGenerated(), this.isFiltered(), this.exceptionMessage);
    }

    public List<ObservablePatternMatch> getMatches() {
        return this.matches;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public boolean isCreated() {
        return this.matcher != null;
    }

    public void stopMonitoring() {
        this.parent.getKey().getEngine().removeModelUpdateListener(this.modelUpdateListener);
    }
}

