/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.content.flyout;

import org.eclipse.incquery.tooling.ui.queryexplorer.content.flyout.FlyoutContainer;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.flyout.IFlyoutPreferences;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class FlyoutControlComposite
extends Composite {
    private final IFlyoutPreferences preferences;
    private final FlyoutContainer flyoutContainer;
    private int minWidth = 100;
    private int validDockLocations = -1;

    public FlyoutControlComposite(Composite parent, int style, IFlyoutPreferences preferences) {
        super(parent, style);
        this.preferences = preferences;
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (FlyoutControlComposite.this.getShell().getMinimized()) {
                    return;
                }
                FlyoutControlComposite.this.layout();
            }
        });
        this.flyoutContainer = new FlyoutContainer(this, 262144);
    }

    public Composite getFlyoutParent() {
        return this.flyoutContainer;
    }

    public Composite getClientParent() {
        return this;
    }

    public void setValidDockLocations(int validDockLocations) {
        this.validDockLocations = validDockLocations;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public void setTitleText(String text) {
        this.flyoutContainer.setTitleText(text);
    }

    public void layout() {
        int offset;
        int width;
        Rectangle clientArea = this.getClientArea();
        int state = this.preferences.getState();
        Control client = this.getChildren()[1];
        if (clientArea.width == 0 || clientArea.height == 0) {
            return;
        }
        if (this.flyoutContainer.getControl() == null) {
            this.flyoutContainer.setBounds(0, 0, 0, 0);
            client.setBounds(clientArea);
            return;
        }
        if (state == 0) {
            width = this.preferences.getWidth();
            width = this.isHorizontal() ? Math.min(clientArea.width / 2, width) : Math.min(clientArea.height / 2, width);
            width = Math.max(width, this.minWidth);
            width = Math.max(width, 2 * this.flyoutContainer.getTitleHeight() + this.flyoutContainer.getTitleWidth());
            this.preferences.setWidth(width);
            offset = width;
        } else if (state == 2) {
            offset = this.flyoutContainer.getTitleHeight();
            width = this.preferences.getWidth();
        } else {
            offset = width = this.flyoutContainer.getTitleHeight();
        }
        if (this.isWest()) {
            this.flyoutContainer.setBounds(0, 0, width, clientArea.height);
            client.setBounds(offset, 0, clientArea.width - offset, clientArea.height);
        } else if (this.isEast()) {
            this.flyoutContainer.setBounds(clientArea.width - width, 0, width, clientArea.height);
            client.setBounds(0, 0, clientArea.width - offset, clientArea.height);
        } else if (this.isNorth()) {
            this.flyoutContainer.setBounds(0, 0, clientArea.width, width);
            client.setBounds(0, offset, clientArea.width, clientArea.height - offset);
        } else if (this.isSouth()) {
            this.flyoutContainer.setBounds(0, clientArea.height - width, clientArea.width, width);
            client.setBounds(0, 0, clientArea.width, clientArea.height - offset);
        }
    }

    public boolean isHorizontal() {
        return this.isWest() || this.isEast();
    }

    public boolean isWest() {
        return this.getDockLocation() == 1;
    }

    public boolean isEast() {
        return this.getDockLocation() == 2;
    }

    public boolean isNorth() {
        return this.getDockLocation() == 4;
    }

    public boolean isSouth() {
        return this.getDockLocation() == 8;
    }

    public boolean isValidDockLocation(int location) {
        return (location & this.validDockLocations) == location;
    }

    public int getDockLocation() {
        return this.preferences.getDockLocation();
    }

    public int getValidDockLocations() {
        return this.validDockLocations;
    }

    public void setDockLocation(int dockLocation) {
        this.preferences.setDockLocation(dockLocation);
        this.layout();
    }

    public IFlyoutPreferences getPreferences() {
        return this.preferences;
    }
}

