/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.validation.core;

import com.google.common.base.Preconditions;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.validation.core.ValidationEngine;
import org.eclipse.incquery.validation.core.api.IValidationEngine;

public class ValidationEngineBuilder {
    private IncQueryEngine incQueryEngine = null;
    private Logger logger = null;

    protected ValidationEngineBuilder() {
    }

    public static ValidationEngineBuilder create() {
        return new ValidationEngineBuilder();
    }

    public IValidationEngine build() {
        Preconditions.checkState((this.incQueryEngine != null ? 1 : 0) != 0, (Object)"Must initialize engine before building!");
        if (this.logger == null) {
            this.logger = Logger.getLogger(ValidationEngine.class);
        }
        Preconditions.checkState((this.logger != null ? 1 : 0) != 0, (Object)"Must initialize logger before building!");
        return new ValidationEngine(this.incQueryEngine, this.logger);
    }

    public ValidationEngineBuilder setEngine(IncQueryEngine engine) {
        Preconditions.checkArgument((engine != null ? 1 : 0) != 0, (Object)"Engine cannot be null!");
        this.incQueryEngine = engine;
        return this;
    }

    public ValidationEngineBuilder setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }
}

