/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import com.google.common.base.Predicate;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.databinding.runtime.api.IncQueryObservables;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.viewers.runtime.model.FormattableElement;

public class Item
extends FormattableElement {
    public static final String ANNOTATION_ID = "Item";
    private final IPatternMatch sourceMatch;
    private final HierarchyPolicy policy;
    private String labelDefinition;
    private Object paramObject;

    public Item(IPatternMatch match, EObject paramObject, String labelDefinition) {
        this(match, paramObject, labelDefinition, HierarchyPolicy.ALWAYS);
    }

    public Item(IPatternMatch match, Object param, String labelDefinition, HierarchyPolicy policy) {
        this.sourceMatch = match;
        this.paramObject = param;
        this.labelDefinition = labelDefinition;
        this.policy = policy;
    }

    public IObservableValue getLabel() {
        if (this.labelDefinition == null || this.labelDefinition.isEmpty()) {
            return Observables.constantObservableValue((Object)"");
        }
        return IncQueryObservables.getObservableLabelFeature((IPatternMatch)this.sourceMatch, (String)this.labelDefinition, (Object)this);
    }

    public Object getParamObject() {
        return this.paramObject;
    }

    public HierarchyPolicy getPolicy() {
        return this.policy;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.labelDefinition == null ? 0 : this.labelDefinition.hashCode());
        result = 31 * result + (this.sourceMatch == null ? 0 : this.sourceMatch.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Item other = (Item)obj;
        if (this.labelDefinition == null ? other.labelDefinition != null : !this.labelDefinition.equals(other.labelDefinition)) {
            return false;
        }
        return !(this.sourceMatch == null ? other.sourceMatch != null : !this.sourceMatch.equals(other.sourceMatch));
    }

    public static final class ChildItem
    implements Predicate<Item> {
        public boolean apply(Item item) {
            if (item == null) {
                return false;
            }
            return item.getPolicy() == HierarchyPolicy.CHILD || item.getPolicy() == HierarchyPolicy.ALWAYS || item.getPolicy() == HierarchyPolicy.PORT;
        }
    }

    public static enum HierarchyPolicy {
        PORT,
        ALWAYS,
        CHILD,
        ROOT;

    }

    public static final class RootItem
    implements Predicate<Item> {
        public boolean apply(Item item) {
            if (item == null) {
                return false;
            }
            return item.getPolicy() == HierarchyPolicy.ROOT || item.getPolicy() == HierarchyPolicy.ALWAYS;
        }
    }
}

