package org.eclipse.incquery.testing.core.base;

import com.google.inject.Inject;
import java.util.HashSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.snapshot.EIQSnapshot.IncQuerySnapshot;
import org.eclipse.incquery.snapshot.EIQSnapshot.MatchSetRecord;
import org.eclipse.incquery.testing.core.ModelLoadHelper;
import org.eclipse.incquery.testing.core.SnapshotHelper;
import org.eclipse.incquery.testing.core.TestExecutor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.junit.Assert;

@SuppressWarnings("all")
public abstract class CommonStaticQueryTester {
  @Inject
  private ModelLoadHelper _modelLoadHelper;
  
  @Inject
  private TestExecutor _testExecutor;
  
  @Inject
  private SnapshotHelper _snapshotHelper;
  
  public void testQuery(final String queryFQN) {
    try {
      final IncQuerySnapshot sns = this.snapshot();
      Notifier _eMFRootForSnapshot = this._snapshotHelper.getEMFRootForSnapshot(sns);
      final IncQueryEngine engine = this.getEngine(_eMFRootForSnapshot);
      PatternModel _queryInputXMI = this.queryInputXMI();
      final IncQueryMatcher matcher = this._modelLoadHelper.initializeMatcherFromModel(_queryInputXMI, engine, queryFQN);
      MatchSetRecord _matchSetRecordForPattern = this._snapshotHelper.getMatchSetRecordForPattern(sns, queryFQN);
      final HashSet<Object> results = this._testExecutor.compareResultSets(matcher, _matchSetRecordForPattern);
      String _logDifference = this._testExecutor.logDifference(results);
      HashSet<Object> _newHashSet = CollectionLiterals.<Object>newHashSet();
      Assert.assertArrayEquals(_logDifference, ((Object[])Conversions.unwrapArray(_newHashSet, Object.class)), ((Object[])Conversions.unwrapArray(results, Object.class)));
    } catch (Exception _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public void testQuery(final IQuerySpecification queryMF) {
    final IncQuerySnapshot sns = this.snapshot();
    Notifier _eMFRootForSnapshot = this._snapshotHelper.getEMFRootForSnapshot(sns);
    final IncQueryEngine engine = this.getEngine(_eMFRootForSnapshot);
    this.testQuery(engine, sns, queryMF);
  }
  
  public void testQuery(final IncQueryEngine engine, final IncQuerySnapshot sns, final IQuerySpecification queryMF) {
    try {
      final IncQueryMatcher matcher = engine.<IncQueryMatcher>getMatcher(queryMF);
      String _patternFullyQualifiedName = queryMF.getPatternFullyQualifiedName();
      MatchSetRecord _matchSetRecordForPattern = this._snapshotHelper.getMatchSetRecordForPattern(sns, _patternFullyQualifiedName);
      final HashSet<Object> results = this._testExecutor.compareResultSets(matcher, _matchSetRecordForPattern);
      String _logDifference = this._testExecutor.logDifference(results);
      HashSet<Object> _newHashSet = CollectionLiterals.<Object>newHashSet();
      Assert.assertArrayEquals(_logDifference, ((Object[])Conversions.unwrapArray(_newHashSet, Object.class)), ((Object[])Conversions.unwrapArray(results, Object.class)));
    } catch (Exception _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public IncQueryEngine getEngine(final Notifier root) {
    try {
      return IncQueryEngine.on(root);
    } catch (Exception _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public IncQuerySnapshot snapshot() {
    String _snapshotURI = this.snapshotURI();
    IncQuerySnapshot _loadExpectedResultsFromUri = this._modelLoadHelper.loadExpectedResultsFromUri(_snapshotURI);
    return ((IncQuerySnapshot) _loadExpectedResultsFromUri);
  }
  
  public PatternModel queryInputXMI() {
    String _queryInputXMIURI = this.queryInputXMIURI();
    PatternModel _loadPatternModelFromUri = this._modelLoadHelper.loadPatternModelFromUri(_queryInputXMIURI);
    return ((PatternModel) _loadPatternModelFromUri);
  }
  
  public abstract String snapshotURI();
  
  public abstract String queryInputXMIURI();
}
