package org.eclipse.incquery.tooling.core.generator.jvmmodel;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.tooling.core.generator.builder.GeneratorIssueCodes;
import org.eclipse.incquery.tooling.core.generator.builder.IErrorFeedback;
import org.eclipse.incquery.tooling.core.generator.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.tooling.core.generator.jvmmodel.PatternGroupClassInferrer;
import org.eclipse.incquery.tooling.core.generator.jvmmodel.PatternMatchClassInferrer;
import org.eclipse.incquery.tooling.core.generator.jvmmodel.PatternMatchEvaluatorClassInferrer;
import org.eclipse.incquery.tooling.core.generator.jvmmodel.PatternMatchProcessorClassInferrer;
import org.eclipse.incquery.tooling.core.generator.jvmmodel.PatternMatcherClassInferrer;
import org.eclipse.incquery.tooling.core.generator.jvmmodel.PatternQuerySpecificationClassInferrer;
import org.eclipse.incquery.tooling.core.generator.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.tooling.core.generator.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.AbstractModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * <p>Infers a JVM model from the source model.</p>
 * 
 * <p>The JVM model should contain all elements that would appear in the Java code
 * which is generated from the source model. Other models link against the JVM model rather than the source model.</p>
 */
@SuppressWarnings("all")
public class EMFPatternLanguageJvmModelInferrer extends AbstractModelInferrer {
  @Inject
  private Logger logger;
  
  @Inject
  private IErrorFeedback errorFeedback;
  
  /**
   * convenience API to build and initialize JvmTypes and their members.
   */
  @Inject
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  private PatternMatchClassInferrer _patternMatchClassInferrer;
  
  @Inject
  private PatternMatcherClassInferrer _patternMatcherClassInferrer;
  
  @Inject
  private PatternQuerySpecificationClassInferrer _patternQuerySpecificationClassInferrer;
  
  @Inject
  private PatternMatchProcessorClassInferrer _patternMatchProcessorClassInferrer;
  
  @Inject
  private PatternMatchEvaluatorClassInferrer _patternMatchEvaluatorClassInferrer;
  
  @Inject
  private PatternGroupClassInferrer _patternGroupClassInferrer;
  
  @Inject
  private JavadocInferrer _javadocInferrer;
  
  @Inject
  private TypeReferences types;
  
  @Inject
  private IJvmModelAssociator associator;
  
  /**
   * Is called for each Pattern instance in a resource.
   * 
   * @param pattern - the model to create one or more JvmDeclaredTypes from.
   * @param acceptor - each created JvmDeclaredType without a container should be passed to the acceptor in order get attached to the
   *                   current resource.
   * @param isPreLinkingPhase - whether the method is called in a pre linking phase, i.e. when the global index isn't fully updated. You
   *        must not rely on linking using the index if iPrelinkingPhase is <code>true</code>
   */
  protected void _infer(final Pattern pattern, final IJvmDeclaredTypeAcceptor acceptor, final boolean isPrelinkingPhase) {
    boolean _isPrivate = CorePatternLanguageHelper.isPrivate(pattern);
    final boolean isPublic = (!_isPrivate);
    final boolean hasCheckExpression = CorePatternLanguageHelper.hasCheckExpression(pattern);
    boolean _and = false;
    String _name = pattern.getName();
    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(_name);
    boolean _not = (!_isNullOrEmpty);
    if (!_not) {
      _and = false;
    } else {
      boolean _or = false;
      if (isPublic) {
        _or = true;
      } else {
        _or = (isPublic || hasCheckExpression);
      }
      _and = (_not && _or);
    }
    if (_and) {
      String _name_1 = pattern.getName();
      String _plus = ("Inferring Jvm Model for " + _name_1);
      this.logger.debug(_plus);
      try {
        final String packageName = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
        final String utilPackageName = this._eMFPatternLanguageJvmModelInferrerUtil.getUtilPackageName(pattern);
        if (isPublic) {
          final JvmDeclaredType matchClass = this._patternMatchClassInferrer.inferMatchClass(pattern, isPrelinkingPhase, packageName);
          final JvmParameterizedTypeReference matchClassRef = this.types.createTypeRef(matchClass);
          final JvmDeclaredType matcherClass = this._patternMatcherClassInferrer.inferMatcherClass(pattern, isPrelinkingPhase, packageName, matchClassRef);
          final JvmParameterizedTypeReference matcherClassRef = this.types.createTypeRef(matcherClass);
          final JvmDeclaredType querySpecificationClass = this._patternQuerySpecificationClassInferrer.inferQuerySpecificationClass(pattern, isPrelinkingPhase, utilPackageName, matchClassRef, matcherClassRef);
          final JvmParameterizedTypeReference querySpecificationClassRef = this.types.createTypeRef(querySpecificationClass);
          final JvmDeclaredType processorClass = this._patternMatchProcessorClassInferrer.inferProcessorClass(pattern, isPrelinkingPhase, utilPackageName, matchClassRef);
          EList<JvmMember> _members = matcherClass.getMembers();
          JvmTypeReference _cloneWithProxies = this._eMFJvmTypesBuilder.cloneWithProxies(matcherClassRef);
          JvmTypeReference _newTypeRef = this._eMFJvmTypesBuilder.newTypeRef(pattern, IQuerySpecification.class, _cloneWithProxies);
          final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
              public void apply(final JvmOperation it) {
                it.setVisibility(JvmVisibility.PUBLIC);
                it.setStatic(true);
                CharSequence _javadocQuerySpecificationMethod = EMFPatternLanguageJvmModelInferrer.this._javadocInferrer.javadocQuerySpecificationMethod(pattern);
                String _string = _javadocQuerySpecificationMethod.toString();
                EMFPatternLanguageJvmModelInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
                EList<JvmTypeReference> _exceptions = it.getExceptions();
                JvmTypeReference _newTypeRef = EMFPatternLanguageJvmModelInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryException.class);
                EMFPatternLanguageJvmModelInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _newTypeRef);
                final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                    public void apply(final ITreeAppendable it) {
                      StringConcatenation _builder = new StringConcatenation();
                      _builder.append("return ");
                      it.append(_builder);
                      EMFPatternLanguageJvmModelInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.serialize(it, querySpecificationClassRef, pattern);
                      StringConcatenation _builder_1 = new StringConcatenation();
                      _builder_1.append(".instance();");
                      it.append(_builder_1);
                    }
                  };
                EMFPatternLanguageJvmModelInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
              }
            };
          JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "querySpecification", _newTypeRef, _function);
          this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
          this.associator.associatePrimary(pattern, matcherClass);
          acceptor.<JvmDeclaredType>accept(matchClass);
          acceptor.<JvmDeclaredType>accept(matcherClass);
          acceptor.<JvmDeclaredType>accept(querySpecificationClass);
          acceptor.<JvmDeclaredType>accept(processorClass);
        }
        if (hasCheckExpression) {
          final List<JvmDeclaredType> evaluatorClassList = this._patternMatchEvaluatorClassInferrer.inferEvaluatorClass(pattern, utilPackageName);
          for (final JvmDeclaredType evaluatorClass : evaluatorClassList) {
            acceptor.<JvmDeclaredType>accept(evaluatorClass);
          }
        }
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception e = (Exception)_t;
          String _plus_1 = ("Exception during Jvm Model Infer for: " + pattern);
          this.logger.error(_plus_1, e);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
  }
  
  /**
   * Is called for each Pattern instance in a resource.
   * 
   * @param pattern - the model to create one or more JvmDeclaredTypes from.
   * @param acceptor - each created JvmDeclaredType without a container should be passed to the acceptor in order get attached to the
   *                   current resource.
   * @param isPreLinkingPhase - whether the method is called in a pre linking phase, i.e. when the global index isn't fully updated. You
   *        must not rely on linking using the index if iPrelinkingPhase is <code>true</code>
   */
  protected void _infer(final PatternModel model, final IJvmDeclaredTypeAcceptor acceptor, final boolean isPrelinkingPhase) {
    try {
      EList<Pattern> _patterns = model.getPatterns();
      for (final Pattern pattern : _patterns) {
        this.infer(pattern, acceptor, isPrelinkingPhase);
      }
      String _modelFileName = this._eMFPatternLanguageJvmModelInferrerUtil.modelFileName(model);
      String _plus = ("Inferring Jvm Model for Pattern model " + _modelFileName);
      this.logger.debug(_plus);
      final JvmGenericType groupClass = this._patternGroupClassInferrer.inferPatternGroup(model);
      this.associator.associatePrimary(model, groupClass);
      acceptor.<JvmGenericType>accept(groupClass);
    } catch (final Throwable _t) {
      if (_t instanceof IllegalArgumentException) {
        final IllegalArgumentException e = (IllegalArgumentException)_t;
        String _message = e.getMessage();
        this.errorFeedback.reportErrorNoLocation(model, _message, GeneratorIssueCodes.INVALID_PATTERN_MODEL_CODE, Severity.ERROR, IErrorFeedback.JVMINFERENCE_ERROR_TYPE);
      } else if (_t instanceof Exception) {
        final Exception e_1 = (Exception)_t;
        String _plus_1 = ("Exception during Jvm Model Infer for pattern model: " + model);
        this.logger.error(_plus_1, e_1);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  public void infer(final EObject model, final IJvmDeclaredTypeAcceptor acceptor, final boolean isPrelinkingPhase) {
    if (model instanceof PatternModel) {
      _infer((PatternModel)model, acceptor, isPrelinkingPhase);
      return;
    } else if (model instanceof Pattern) {
      _infer((Pattern)model, acceptor, isPrelinkingPhase);
      return;
    } else if (model != null) {
      _infer(model, acceptor, isPrelinkingPhase);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(model, acceptor, isPrelinkingPhase).toString());
    }
  }
}
