/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.wizards.internal;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.incquery.tooling.ui.IncQueryGUIPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class ImportListLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider {
    private ImageRegistry imageRegistry = IncQueryGUIPlugin.getDefault().getImageRegistry();

    public Image getImage(Object element) {
        if (element instanceof EPackage) {
            return this.imageRegistry.get("epackage");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof EPackage) {
            return ((EPackage)element).getNsURI();
        }
        return null;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        StyledString text = new StyledString();
        if (element instanceof EPackage) {
            EPackage ePackage = (EPackage)element;
            text.append(ePackage.getNsURI());
            if (ePackage.eResource().getURI().isPlatform()) {
                text.append(String.format(" (%s)", ePackage.eResource().getURI()), StyledString.QUALIFIER_STYLER);
            }
            cell.setImage(this.imageRegistry.get("epackage"));
        }
        cell.setText(text.getString());
        cell.setStyleRanges(text.getStyleRanges());
        super.update(cell);
    }
}

