/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.basiclinear;

import java.util.Collections;
import java.util.Set;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.construction.Buildable;
import org.eclipse.incquery.runtime.rete.construction.IReteLayoutStrategy;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.construction.basiclinear.OrderingHeuristics;
import org.eclipse.incquery.runtime.rete.construction.helpers.BuildHelper;
import org.eclipse.incquery.runtime.rete.construction.helpers.LayoutHelper;
import org.eclipse.incquery.runtime.rete.construction.psystem.DeferredPConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.EnumerablePConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PSystem;
import org.eclipse.incquery.runtime.rete.matcher.IPatternMatcherContext;

public class BasicLinearLayout<PatternDescription, StubHandle, Collector>
implements IReteLayoutStrategy<PatternDescription, StubHandle, Collector> {
    @Override
    public Stub<StubHandle> layout(PSystem<PatternDescription, StubHandle, Collector> pSystem) throws RetePatternBuildException {
        PatternDescription pattern = pSystem.getPattern();
        IPatternMatcherContext<PatternDescription> context = pSystem.getContext();
        Buildable<PatternDescription, StubHandle, Collector> buildable = pSystem.getBuildable();
        try {
            context.logDebug(String.format("%s: patternbody build started for %s", this.getClass().getSimpleName(), context.printPattern(pattern)));
            LayoutHelper.unifyVariablesAlongEqualities(pSystem);
            LayoutHelper.eliminateWeakInequalities(pSystem);
            LayoutHelper.eliminateInferrableUnaryTypes(pSystem, context);
            LayoutHelper.checkSanity(pSystem);
            Stub<StubHandle> stub = buildable.buildStartStub(new Object[0], new Object[0]);
            Set<PConstraint> pQueue = CollectionsFactory.getSet(pSystem.getConstraints());
            while (!pQueue.isEmpty()) {
                PConstraint pConstraint = Collections.min(pQueue, new OrderingHeuristics(stub));
                pQueue.remove(pConstraint);
                if (pConstraint instanceof EnumerablePConstraint) {
                    EnumerablePConstraint enumerable = (EnumerablePConstraint)pConstraint;
                    Stub sideStub = enumerable.getStub();
                    stub = BuildHelper.naturalJoin(buildable, stub, sideStub);
                    continue;
                }
                DeferredPConstraint deferred = (DeferredPConstraint)pConstraint;
                if (deferred.isReadyAt(stub)) {
                    stub = deferred.checkOn(stub);
                    continue;
                }
                deferred.raiseForeverDeferredError(stub);
            }
            LayoutHelper.finalCheck(pSystem, stub);
            context.logDebug(String.format("%s: patternbody build concluded for %s", this.getClass().getSimpleName(), context.printPattern(pattern)));
            return stub;
        }
        catch (RetePatternBuildException ex) {
            ex.setPatternDescription(pattern);
            throw ex;
        }
    }
}

