/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction;

import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.matcher.IPatternMatcherContext;

public class CodegenRecordingCoordinator<PatternDescription> {
    protected static final String varPrefix = "var";
    protected static final String buildablePrefix = "buildable";
    protected static final String collectorPrefix = "production";
    public Long nextIdentifier;
    public String stubType;
    public String collectorType;
    public String buildableType;
    Map<PatternDescription, StringBuilder> builderCode;
    public IPatternMatcherContext<PatternDescription> targetContext;

    public CodegenRecordingCoordinator(IPatternMatcherContext<PatternDescription> targetContext, String stubType, String collectorType, String buildableType) {
        this.targetContext = targetContext;
        this.nextIdentifier = 0L;
        this.stubType = stubType;
        this.collectorType = collectorType;
        this.buildableType = buildableType;
        this.builderCode = CollectionsFactory.getMap();
    }

    String newIdentifier(String prefix) {
        Long l = this.nextIdentifier;
        this.nextIdentifier = l + 1L;
        return String.valueOf(prefix) + "_" + l.toString();
    }

    String newVariableIdentifier() {
        return this.newIdentifier(varPrefix);
    }

    String newBuildableIdentifier() {
        return this.newIdentifier(buildablePrefix);
    }

    String newCollectorIdentifier() {
        return this.newIdentifier(collectorPrefix);
    }

    public void emitPatternBuilderLine(PatternDescription effort, String indent, String line) {
        StringBuilder sb = this.getBuilder(effort);
        this.emitLine(sb, indent, line);
    }

    StringBuilder getBuilder(PatternDescription effort) {
        if (effort == null) {
            throw new UnsupportedOperationException("Build actions must be put on the tab of a pattern");
        }
        StringBuilder result = this.builderCode.get(effort);
        if (result == null) {
            result = new StringBuilder();
            this.builderCode.put(effort, result);
        }
        return result;
    }

    private void emitLine(StringBuilder where, String indent, String line) {
        where.append(indent);
        where.append(line);
        where.append(System.getProperty("line.separator"));
    }

    public String getFinishedBuilderCode(PatternDescription pattern) {
        return this.builderCode.get(pattern).toString();
    }

    public Set<PatternDescription> getBuiltPatterns() {
        return this.builderCode.keySet();
    }
}

