/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.adapters;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.incquery.tooling.ui.queryexplorer.adapters.EMFModelConnector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class EIQEditorModelConnector
extends EMFModelConnector {
    private final IResourceSetProvider resourceSetProvider;

    public EIQEditorModelConnector(IEditorPart editorPart, IResourceSetProvider resourceSetProvider) {
        super(editorPart);
        this.resourceSetProvider = resourceSetProvider;
    }

    @Override
    public Notifier getNotifier(IModelConnectorTypeEnum modelConnectorTypeEnum) {
        IFile file;
        Resource result = null;
        if (IModelConnectorTypeEnum.RESOURCESET.equals((Object)modelConnectorTypeEnum)) {
            IFile file2 = (IFile)this.editorPart.getEditorInput().getAdapter(IFile.class);
            if (file2 != null) {
                result = this.loadEIQFile(file2);
            }
        } else if (IModelConnectorTypeEnum.RESOURCE.equals((Object)modelConnectorTypeEnum) && (file = (IFile)this.editorPart.getEditorInput().getAdapter(IFile.class)) != null) {
            result = this.loadEIQFile(file);
        }
        return result;
    }

    private Resource loadEIQFile(IFile file) {
        ResourceSet resourceSet = this.resourceSetProvider.get(file.getProject());
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        return resourceSet.getResource(fileURI, true);
    }

    @Override
    public void showLocation(Object[] locationObjects) {
    }
}

