/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.content.flyout;

import org.eclipse.incquery.tooling.ui.queryexplorer.content.flyout.FlyoutConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class DrawUtils {
    public static void drawImageCHCV(GC gc, Image image, int x, int y, int width, int height) {
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            int centerX = (width - imageBounds.width) / 2;
            int centerY = y + (height - imageBounds.height) / 2;
            gc.drawImage(image, x + centerX, centerY);
        }
    }

    public static void drawHighlightRectangle(GC gc, int x, int y, int width, int height) {
        int right = x + width - 1;
        int bottom = y + height - 1;
        Color oldForeground = gc.getForeground();
        try {
            gc.setForeground(FlyoutConstants.buttonLightest);
            gc.drawLine(x, y, right, y);
            gc.drawLine(x, y, x, bottom);
            gc.setForeground(FlyoutConstants.buttonDarker);
            gc.drawLine(right, y, right, bottom);
            gc.drawLine(x, bottom, right, bottom);
        }
        finally {
            gc.setForeground(oldForeground);
        }
    }

    public static Image createRotatedImage(Image srcImage) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        ImageData srcData = srcImage.getImageData();
        ImageData destData = srcData.depth < 8 ? DrawUtils.rotatePixelByPixel(srcData) : DrawUtils.rotateOptimized(srcData);
        return new Image((Device)display, destData);
    }

    private static ImageData rotatePixelByPixel(ImageData srcData) {
        ImageData destData = new ImageData(srcData.height, srcData.width, srcData.depth, srcData.palette);
        int y = 0;
        while (y < srcData.height) {
            int x = 0;
            while (x < srcData.width) {
                destData.setPixel(y, srcData.width - x - 1, srcData.getPixel(x, y));
                ++x;
            }
            ++y;
        }
        return destData;
    }

    private static ImageData rotateOptimized(ImageData srcData) {
        int bytesPerPixel = Math.max(1, srcData.depth / 8);
        int destBytesPerLine = ((srcData.height * bytesPerPixel - 1) / srcData.scanlinePad + 1) * srcData.scanlinePad;
        byte[] newData = new byte[destBytesPerLine * srcData.width];
        int srcY = 0;
        while (srcY < srcData.height) {
            int srcX = 0;
            while (srcX < srcData.width) {
                int destX = srcY;
                int destY = srcData.width - srcX - 1;
                int destIndex = destY * destBytesPerLine + destX * bytesPerPixel;
                int srcIndex = srcY * srcData.bytesPerLine + srcX * bytesPerPixel;
                System.arraycopy(srcData.data, srcIndex, newData, destIndex, bytesPerPixel);
                ++srcX;
            }
            ++srcY;
        }
        return new ImageData(srcData.height, srcData.width, srcData.depth, srcData.palette, srcData.scanlinePad, newData);
    }
}

