package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.uml.derivedfeatures.util.VertexIncomingQuerySpecification;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;

/**
 * Pattern-specific match representation of the org.eclipse.incquery.uml.derivedfeatures.vertexIncoming pattern,
 * to be used in conjunction with {@link VertexIncomingMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see VertexIncomingMatcher
 * @see VertexIncomingProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class VertexIncomingMatch extends BasePatternMatch {
  private Vertex fSelf;
  
  private Transition fTemp1;
  
  private static List<String> parameterNames = makeImmutableList("self", "temp1");
  
  private VertexIncomingMatch(final Vertex pSelf, final Transition pTemp1) {
    this.fSelf = pSelf;
    this.fTemp1 = pTemp1;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("self".equals(parameterName)) return this.fSelf;
    if ("temp1".equals(parameterName)) return this.fTemp1;
    return null;
  }
  
  public Vertex getSelf() {
    return this.fSelf;
  }
  
  public Transition getTemp1() {
    return this.fTemp1;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("self".equals(parameterName) ) {
    	this.fSelf = (org.eclipse.uml2.uml.Vertex) newValue;
    	return true;
    }
    if ("temp1".equals(parameterName) ) {
    	this.fTemp1 = (org.eclipse.uml2.uml.Transition) newValue;
    	return true;
    }
    return false;
  }
  
  public void setSelf(final Vertex pSelf) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fSelf = pSelf;
  }
  
  public void setTemp1(final Transition pTemp1) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTemp1 = pTemp1;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.incquery.uml.derivedfeatures.vertexIncoming";
  }
  
  @Override
  public List<String> parameterNames() {
    return VertexIncomingMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fSelf, fTemp1};
  }
  
  @Override
  public VertexIncomingMatch toImmutable() {
    return isMutable() ? newMatch(fSelf, fTemp1) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"self\"=" + prettyPrintValue(fSelf) + ", ");
    
    result.append("\"temp1\"=" + prettyPrintValue(fTemp1)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fSelf == null) ? 0 : fSelf.hashCode());
    result = prime * result + ((fTemp1 == null) ? 0 : fTemp1.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof VertexIncomingMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    VertexIncomingMatch other = (VertexIncomingMatch) obj;
    if (fSelf == null) {if (other.fSelf != null) return false;}
    else if (!fSelf.equals(other.fSelf)) return false;
    if (fTemp1 == null) {if (other.fTemp1 != null) return false;}
    else if (!fTemp1.equals(other.fTemp1)) return false;
    return true;
  }
  
  @Override
  public VertexIncomingQuerySpecification specification() {
    try {
    	return VertexIncomingQuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static VertexIncomingMatch newEmptyMatch() {
    return new Mutable(null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static VertexIncomingMatch newMutableMatch(final Vertex pSelf, final Transition pTemp1) {
    return new Mutable(pSelf, pTemp1);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static VertexIncomingMatch newMatch(final Vertex pSelf, final Transition pTemp1) {
    return new Immutable(pSelf, pTemp1);
  }
  
  private static final class Mutable extends VertexIncomingMatch {
    Mutable(final Vertex pSelf, final Transition pTemp1) {
      super(pSelf, pTemp1);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends VertexIncomingMatch {
    Immutable(final Vertex pSelf, final Transition pTemp1) {
      super(pSelf, pTemp1);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
