/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.module.soap;

import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.module.ClientAuthModule;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class TSSendFailureClientAuthModule
implements ClientAuthModule {
    private static TSLogger logger = null;
    private static Map options = null;

    public void initialize(MessagePolicy reqPolicy, MessagePolicy resPolicy, CallbackHandler handler, Map optns) throws AuthException {
        options = optns;
        if (options.get("TSLogger") != null) {
            logger = (TSLogger)options.get("TSLogger");
        }
    }

    public Class[] getSupportedMessageTypes() {
        Class[] classarray = new Class[]{SOAPMessage.class};
        this.logMsg("TSSendFailureClientAuthModule.getSupportedMessageTypes called");
        return classarray;
    }

    public AuthStatus secureRequest(MessageInfo messageInfo, Subject clientSubject) throws AuthException {
        String msg = "TSSendFailureClientAuthModule.secureRequest called";
        this.logMsg(msg);
        return AuthStatus.SEND_SUCCESS;
    }

    public AuthStatus validateResponse(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        String msg = "TSSendFailureClientAuthModule.validateResponse called";
        this.logMsg(msg);
        SOAPMessage smsg = (SOAPMessage)messageInfo.getResponseMessage();
        String faultString = this.getSOAPFaultString(smsg);
        if (faultString != null) {
            msg = "TSSendFailureClientAuthModule.validateResponse received SOAPFault :" + faultString;
            this.logMsg(msg);
        }
        return AuthStatus.SUCCESS;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        this.logMsg("TSSendFailureClientAuthModule.cleanSubject called");
        subject = null;
    }

    public void logMsg(String str) {
        if (logger != null) {
            logger.log(Level.INFO, str);
        } else {
            System.out.println("*** TSLogger Not Initialized properly ***");
            System.out.println("*** TSSVLogMessage : ***" + str);
        }
    }

    private String getSOAPFaultString(SOAPMessage smsg) {
        String faultString = null;
        SOAPPart soap = smsg.getSOAPPart();
        if (soap != null) {
            try {
                SOAPBody body;
                SOAPEnvelope envelope = soap.getEnvelope();
                if (envelope != null && (body = envelope.getBody()) != null && body.hasFault()) {
                    SOAPFault sf = body.getFault();
                    faultString = sf.getFaultString();
                }
            }
            catch (SOAPException se) {
                logger.log(Level.INFO, "Error adding SOAP Fault", se);
            }
        }
        return faultString;
    }
}

