/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.internal.impl;

import java.awt.image.BufferedImage;
import java.net.ConnectException;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUT;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.client.exceptions.ActionException;
import org.eclipse.jubula.client.exceptions.CheckFailedException;
import org.eclipse.jubula.client.exceptions.ComponentNotFoundException;
import org.eclipse.jubula.client.exceptions.ConfigurationException;
import org.eclipse.jubula.client.exceptions.ExecutionException;
import org.eclipse.jubula.client.exceptions.ExecutionExceptionHandler;
import org.eclipse.jubula.client.internal.AUTConnection;
import org.eclipse.jubula.client.internal.BaseConnection;
import org.eclipse.jubula.client.internal.Synchronizer;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.client.internal.impl.AUTAgentImpl;
import org.eclipse.jubula.client.internal.impl.ResultImpl;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.communication.internal.message.CAPTestMessage;
import org.eclipse.jubula.communication.internal.message.CAPTestResponseMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.SetProfileMessage;
import org.eclipse.jubula.communication.internal.message.TakeScreenshotMessage;
import org.eclipse.jubula.communication.internal.message.TakeScreenshotResponseMessage;
import org.eclipse.jubula.communication.internal.message.UnknownMessageException;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.internal.AbstractToolkitInfo;
import org.eclipse.jubula.tools.AUTIdentifier;
import org.eclipse.jubula.tools.Profile;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.objects.event.TestErrorEvent;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.serialisation.SerializedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AUTImpl
implements AUT {
    private static Logger log = LoggerFactory.getLogger(AUTImpl.class);
    @NonNull
    private AutIdentifier m_autID;
    private AUTConnection m_instance;
    private AbstractToolkitInfo m_information;
    private ExecutionExceptionHandler m_handler;

    public AUTImpl(@NonNull AutIdentifier autID, @NonNull ToolkitInfo information) {
        Validate.notNull((Object)autID, (String)"The AUT-Identifier must not be null.");
        Validate.notNull((Object)information, (String)"The toolkit information must not be null.");
        this.m_autID = autID;
        this.setToolkitInformation((AbstractToolkitInfo)information);
    }

    @Override
    public void connect() throws org.eclipse.jubula.client.exceptions.CommunicationException {
        block4: {
            if (!this.isConnected()) {
                Map typeMapping = this.getInformation().getTypeMapping();
                try {
                    this.m_instance = AUTConnection.getInstance();
                    this.m_instance.connectToAut(this.m_autID, typeMapping);
                    if (!this.isConnected()) {
                        throw new org.eclipse.jubula.client.exceptions.CommunicationException(new ConnectException("Could not connect to AUT: " + this.m_autID.getID() + "."));
                    }
                    break block4;
                }
                catch (ConnectionException e) {
                    log.error(e.getLocalizedMessage(), (Throwable)((Object)e));
                    throw new org.eclipse.jubula.client.exceptions.CommunicationException((Throwable)((Object)e));
                }
            }
            throw new IllegalStateException("AUT connection is already made");
        }
    }

    @Override
    public void disconnect() {
        if (!this.isConnected()) {
            throw new IllegalStateException("AUT connection is already disconnected");
        }
        this.m_instance.close();
    }

    @Override
    public boolean isConnected() {
        return this.m_instance != null ? this.m_instance.isConnected() : false;
    }

    @Override
    @NonNull
    public AUTIdentifier getIdentifier() {
        return this.m_autID;
    }

    private void setToolkitInformation(AbstractToolkitInfo information) {
        this.m_information = information;
    }

    public AbstractToolkitInfo getInformation() {
        return this.m_information;
    }

    @Override
    @NonNull
    public <T> Result<T> execute(@NonNull CAP cap, @Nullable T payload) throws ExecutionException, org.eclipse.jubula.client.exceptions.CommunicationException {
        Validate.notNull((Object)cap, (String)"The CAP must not be null.");
        AUTAgentImpl.checkConnected(this);
        ResultImpl<T> result = new ResultImpl<T>(cap, payload);
        try {
            CAPTestMessage capTestMessage = new CAPTestMessage((MessageCap)cap);
            this.m_instance.send((Message)capTestMessage);
            Object exchange = Synchronizer.instance().exchange(null);
            if (exchange instanceof CAPTestResponseMessage) {
                CAPTestResponseMessage response = exchange;
                this.processResponse(response, result);
                result.setOK(true);
            } else {
                log.error("Unexpected response received: " + String.valueOf(exchange));
            }
        }
        catch (BaseConnection.NotConnectedException e) {
            throw new org.eclipse.jubula.client.exceptions.CommunicationException((Throwable)((Object)e));
        }
        catch (UnknownMessageException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new org.eclipse.jubula.client.exceptions.CommunicationException(e);
        }
        catch (CommunicationException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new org.eclipse.jubula.client.exceptions.CommunicationException(e);
        }
        catch (InterruptedException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new org.eclipse.jubula.client.exceptions.CommunicationException(e);
        }
        return result;
    }

    private void processResponse(CAPTestResponseMessage response, @NonNull ResultImpl result) throws ExecutionException {
        ExecutionException exception = null;
        if (response.hasTestErrorEvent()) {
            TestErrorEvent event = response.getTestErrorEvent();
            String eventId = event.getId();
            Map eventProps = event.getProps();
            String description = null;
            if (eventProps.containsKey("guidancerErrorDescription")) {
                String key = (String)eventProps.get("guidancerErrorDescription");
                Object[] args = (Object[])eventProps.get("guidancerErrorParameter");
                args = args != null ? args : new Object[]{};
                description = I18n.getString((String)key, (Object[])args);
            }
            if ("TestErrorEvent.Action".equals(eventId)) {
                exception = new ActionException(result, description);
            } else if ("TestErrorEvent.CompNotFound".equals(eventId)) {
                exception = new ComponentNotFoundException(result, description);
            } else if ("TestErrorEvent.Config".equals(eventId)) {
                exception = new ConfigurationException(result, description);
            } else if ("TestErrorEvent.VerifyFailed".equals(eventId)) {
                Object actualValueObject = event.getProps().get("guidancerActualValue");
                String actualValue = "n/a";
                if (actualValueObject instanceof String) {
                    actualValue = (String)actualValueObject;
                }
                exception = new CheckFailedException(result, description, actualValue);
            }
        }
        result.setException(exception);
        if (exception != null) {
            if (this.m_handler != null) {
                this.m_handler.handle(exception);
            } else {
                throw exception;
            }
        }
    }

    @Override
    public void setHandler(@Nullable ExecutionExceptionHandler handler) {
        this.m_handler = handler;
    }

    @Override
    public BufferedImage getScreenshot() throws IllegalStateException {
        block11: {
            if (this.isConnected()) {
                TakeScreenshotMessage message = new TakeScreenshotMessage();
                try {
                    this.m_instance.send((Message)message);
                    Object exchange = Synchronizer.instance().exchange(null);
                    if (exchange instanceof TakeScreenshotResponseMessage) {
                        TakeScreenshotResponseMessage response = exchange;
                        return SerializedImage.computeImage((SerializedImage)response.getScreenshot());
                    }
                    log.error("Unexpected response received: " + String.valueOf(exchange));
                }
                catch (BaseConnection.NotConnectedException nce) {
                    if (log.isErrorEnabled()) {
                        log.error(nce.getLocalizedMessage(), (Throwable)((Object)nce));
                    }
                    break block11;
                }
                catch (IllegalArgumentException e) {
                    if (log.isErrorEnabled()) {
                        log.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                    break block11;
                }
                catch (CommunicationException e) {
                    if (log.isErrorEnabled()) {
                        log.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                    break block11;
                }
                catch (InterruptedException e) {
                    if (log.isErrorEnabled()) {
                        log.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                    break block11;
                }
            }
            throw new IllegalStateException("No AUT connection!");
        }
        return null;
    }

    @Override
    public void setProfile(Profile profile) throws IllegalArgumentException, IllegalStateException, org.eclipse.jubula.client.exceptions.CommunicationException {
        block9: {
            if (profile == null) {
                throw new IllegalArgumentException("Profile is null");
            }
            if (this.isConnected()) {
                SetProfileMessage message = new SetProfileMessage();
                message.setProfile((org.eclipse.jubula.tools.internal.xml.businessmodell.Profile)profile);
                try {
                    this.m_instance.send((Message)message);
                }
                catch (BaseConnection.NotConnectedException nce) {
                    if (log.isErrorEnabled()) {
                        log.error(nce.getLocalizedMessage(), (Throwable)((Object)nce));
                    }
                    break block9;
                }
                catch (IllegalArgumentException e) {
                    if (log.isErrorEnabled()) {
                        log.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                    break block9;
                }
                catch (CommunicationException e) {
                    if (log.isErrorEnabled()) {
                        log.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                    break block9;
                }
            }
            throw new IllegalStateException("No AUT connection!");
        }
    }
}

