/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.analyze.impl.standard.analyze;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jubula.client.analyze.definition.IAnalyze;
import org.eclipse.jubula.client.analyze.internal.AnalyzeParameter;
import org.eclipse.jubula.client.analyze.internal.AnalyzeResult;
import org.eclipse.jubula.client.analyze.internal.helper.ProjectContextHelper;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericalProjectElementCounter
implements IAnalyze {
    public AnalyzeResult execute(Object obj2analyze, IProgressMonitor monitor, String resultType, List<AnalyzeParameter> param, String analyzeName) {
        int workAmount = 1;
        if (obj2analyze instanceof IProjectPO) {
            workAmount = (int)NodePM.getNumNodes((long)((IProjectPO)obj2analyze).getId(), (EntityManager)GeneralStorage.getInstance().getMasterSession());
        } else if (obj2analyze instanceof INodePO) {
            workAmount = (int)NodePM.getNumNodes((long)((INodePO)obj2analyze).getParentProjectId(), (EntityManager)GeneralStorage.getInstance().getMasterSession());
        }
        monitor.beginTask("", workAmount);
        monitor.subTask(analyzeName);
        CountElementOperation c = new CountElementOperation(monitor);
        this.traverse(c, obj2analyze, ProjectContextHelper.getObjContType());
        monitor.worked(1);
        if (monitor.isCanceled()) {
            monitor.done();
            throw new OperationCanceledException();
        }
        return new AnalyzeResult(resultType, c.getAmount());
    }

    private void traverse(CountElementOperation count, Object obj, String objContType) {
        TreeTraverser tt;
        INodePO root;
        if (obj instanceof INodePO && objContType.equals("IExecObjContPO")) {
            root = (INodePO)obj;
            tt = new TreeTraverser(root, (ITreeNodeOperation)count, true, true){

                protected void traverseReusedProjectSpecPart(ITreeTraverserContext<INodePO> context, IProjectPO project) {
                }
            };
            tt.traverse(true);
        } else if (obj instanceof INodePO && objContType.equals("ISpecObjContPO")) {
            root = (INodePO)obj;
            tt = new TreeTraverser(root, (ITreeNodeOperation)count, true, false){

                protected void traverseReusedProjectSpecPart(ITreeTraverserContext<INodePO> context, IProjectPO project) {
                }
            };
            tt.traverse(true);
        }
        if (obj instanceof INodePO && objContType.equals("project")) {
            root = (INodePO)obj;
            tt = new TreeTraverser(root, (ITreeNodeOperation)count, true, true){

                protected void traverseReusedProjectSpecPart(ITreeTraverserContext<INodePO> context, IProjectPO project) {
                }
            };
            tt.traverse(true);
        }
        if (obj instanceof INodePO && objContType.equals("")) {
            root = (INodePO)obj;
            tt = new TreeTraverser(root, (ITreeNodeOperation)count, true, true){

                protected void traverseReusedProjectSpecPart(ITreeTraverserContext<INodePO> context, IProjectPO project) {
                }
            };
            tt.traverse(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CountElementOperation
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private Map<Class<? extends INodePO>, Integer> m_amount = new HashMap<Class<? extends INodePO>, Integer>();
        private IProgressMonitor m_pm;

        public CountElementOperation(IProgressMonitor monitor) {
            this.setProgressMonitor(monitor);
        }

        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            long nodeParentProjectID;
            if (node instanceof IProjectPO) {
                return !alreadyVisited;
            }
            long currentProjectID = GeneralStorage.getInstance().getProject().getId();
            if (currentProjectID != (nodeParentProjectID = node.getParentProjectId().longValue())) {
                return alreadyVisited;
            }
            Class<?> nodeType = null;
            if (node instanceof ICategoryPO || node instanceof ISpecTestCasePO || node instanceof ITestSuitePO || node instanceof ITestJobPO || node instanceof IRefTestSuitePO) {
                nodeType = node.getClass();
            }
            if ((node instanceof IEventExecTestCasePO || node instanceof ICapPO || node instanceof IExecTestCasePO) && !(parent instanceof IExecTestCasePO)) {
                nodeType = node.getClass();
            }
            if (nodeType != null) {
                Integer ccount = this.getAmount().get(nodeType);
                if (ccount == null) {
                    ccount = new Integer(0);
                }
                Integer nCount = ccount + 1;
                this.getAmount().put(nodeType, nCount);
                this.getProgressMonitor().worked(1);
                if (this.getProgressMonitor().isCanceled()) {
                    this.getProgressMonitor().done();
                    throw new OperationCanceledException();
                }
            }
            return !alreadyVisited;
        }

        public Map<Class<? extends INodePO>, Integer> getAmount() {
            return this.m_amount;
        }

        public IProgressMonitor getProgressMonitor() {
            return this.m_pm;
        }

        public void setProgressMonitor(IProgressMonitor monitor) {
            this.m_pm = monitor;
        }
    }
}

