/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.swing;

import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.swing.internal.SwingToolkitInfo;

/**
 * Factory for creating components from the swing toolkit.
 * @noextend This class is not intended to be extended by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.FactoryGenerator", 
           date =  "2016-02-04T15:41:37.042Z")
public final class SwingComponents {
    
    @NonNull private final static ToolkitInfo m_toolkitInformation = new SwingToolkitInfo();

    private SwingComponents() {
        super();
    }
    
    @NonNull public static ToolkitInfo getToolkitInformation() {
        return m_toolkitInformation;
    }

    /** create a new representative for a {@link Application} component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.Application createApplication () {
        return new org.eclipse.jubula.toolkit.swing.internal.impl.Application();
    }
    /** create a new representative for a {@link javax.swing.AbstractButton} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createAbstractButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.AbstractButton(componentIdentifier);
    }
    /** create a new representative for a {@link JMenuBar} component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.MenuBarComponent createJMenuBar () {
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JMenuBar();
    }
    /** create a new representative for a {@link javax.swing.JComboBox} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createJComboBox (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ComboComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JComboBox(componentIdentifier);
    }
    /** create a new representative for a {@link javax.swing.JList} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createJList (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ListComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JList(componentIdentifier);
    }
    /** create a new representative for a {@link javax.swing.JLabel} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createJLabel (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JLabel(componentIdentifier);
    }
    /** create a new representative for a {@link javax.swing.JTabbedPane} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TabComponent createJTabbedPane (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TabComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JTabbedPane(componentIdentifier);
    }
    /** create a new representative for a {@link javax.swing.JTable} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TableComponent createJTable (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TableComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JTable(componentIdentifier);
    }
    /** create a new representative for a {@link javax.swing.text.JTextComponent} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createJTextComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JTextComponent(componentIdentifier);
    }
    /** create a new representative for a {@link javax.swing.JTree} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TreeComponent createJTree (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TreeComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JTree(componentIdentifier);
    }
    /** create a new representative for a {@link javax.swing.JProgressBar} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.base.components.GraphicsComponent createJProgressBar (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.GraphicsComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JProgressBar(componentIdentifier);
    }
}