/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.api.gen;

import java.util.List;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.CommonGenInfo;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.CompInfoForFactoryGen;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.FactoryGenInfo;
import org.eclipse.jubula.toolkit.api.gen.internal.utils.GenerateUtil;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ComponentClass;

public class FactoryGenerator {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "/*******************************************************************************" + this.NL + " * Copyright (c) 2014 BREDEX GmbH." + this.NL + " * All rights reserved. This program and the accompanying materials" + this.NL + " * are made available under the terms of the Eclipse Public License v1.0" + this.NL + " * which accompanies this distribution, and is available at" + this.NL + " * http://www.eclipse.org/legal/epl-v10.html" + this.NL + " *" + this.NL + " * Contributors:" + this.NL + " *     BREDEX GmbH - initial API and implementation and/or initial documentation" + this.NL + " *******************************************************************************/" + this.NL + "package ";
    protected final String TEXT_2 = ";" + this.NL + this.NL + "import javax.annotation.Generated;" + this.NL + this.NL + "import org.apache.commons.lang.Validate;" + this.NL + "import org.eclipse.jdt.annotation.NonNull;" + this.NL + "import org.eclipse.jubula.tools.ComponentIdentifier;" + this.NL + "import org.eclipse.jubula.toolkit.annotations.Beta;" + this.NL + "import org.eclipse.jubula.toolkit.ToolkitInfo;" + this.NL;
    protected final String TEXT_3 = "import ";
    protected final String TEXT_4 = ";";
    protected final String TEXT_5 = String.valueOf(this.NL) + this.NL + "/**" + this.NL + " * Factory for creating components from the ";
    protected final String TEXT_6 = " toolkit." + this.NL + " * @noextend This class is not intended to be extended by clients." + this.NL + " */" + this.NL + "@Generated(value = \"";
    protected final String TEXT_7 = "\", " + this.NL + "           date =  \"";
    protected final String TEXT_8 = "\")" + this.NL + "public class ";
    protected final String TEXT_9 = " {" + this.NL + "    ";
    protected final String TEXT_10 = String.valueOf(this.NL) + "    @NonNull private final static ToolkitInfo TOOLKIT_INFORMATION = ";
    protected final String TEXT_11 = "Toolkit.createToolkitInformation();";
    protected final String TEXT_12 = String.valueOf(this.NL) + this.NL + "    private ";
    protected final String TEXT_13 = "() {" + this.NL + "        super();" + this.NL + "    }" + this.NL + "    ";
    protected final String TEXT_14 = String.valueOf(this.NL) + "    /** " + this.NL + "     *  @return the toolkit information, not recommended to be modified" + this.NL + "     */" + this.NL + "    @NonNull public static ToolkitInfo getToolkitInformation() {" + this.NL + "        return TOOLKIT_INFORMATION;" + this.NL + "    }";
    protected final String TEXT_15 = this.NL;
    protected final String TEXT_16 = String.valueOf(this.NL) + "    /** create a new representative for a {@link ";
    protected final String TEXT_17 = "} component." + this.NL + "     * ";
    protected final String TEXT_18 = String.valueOf(this.NL) + "     */" + this.NL + "    @NonNull public static ";
    protected final String TEXT_19 = " create";
    protected final String TEXT_20 = " () {" + this.NL + "        return new ";
    protected final String TEXT_21 = "();" + this.NL + "    }";
    protected final String TEXT_22 = String.valueOf(this.NL) + "    /** create a new representative for a ";
    protected final String TEXT_23 = "{@link ";
    protected final String TEXT_24 = "}";
    protected final String TEXT_25 = " UI component." + this.NL + "     * ";
    protected final String TEXT_26 = String.valueOf(this.NL) + "     */" + this.NL + "    @NonNull public static ";
    protected final String TEXT_27 = " create";
    protected final String TEXT_28 = " (@NonNull ComponentIdentifier<? extends ";
    protected final String TEXT_29 = "> componentIdentifier) {" + this.NL + "        Validate.notNull(componentIdentifier);" + this.NL + "        return new ";
    protected final String TEXT_30 = "(componentIdentifier);" + this.NL + "    }";
    protected final String TEXT_31 = String.valueOf(this.NL) + "    ";
    protected final String TEXT_32 = String.valueOf(this.NL) + "    /** create a new instance of ";
    protected final String TEXT_33 = "ActionHandler " + this.NL + "     * ";
    protected final String TEXT_34 = String.valueOf(this.NL) + "     */" + this.NL + "    @NonNull public static ";
    protected final String TEXT_35 = " create";
    protected final String TEXT_36 = "ActionHandler () {" + this.NL + "        return new ";
    protected final String TEXT_37 = "();" + this.NL + "    }";
    protected final String TEXT_38 = String.valueOf(this.NL) + "    /** create a new representative for a ";
    protected final String TEXT_39 = "{@link ";
    protected final String TEXT_40 = "}";
    protected final String TEXT_41 = " UI component." + this.NL + "     * ";
    protected final String TEXT_42 = String.valueOf(this.NL) + "     */" + this.NL + "    @NonNull public static ";
    protected final String TEXT_43 = " create";
    protected final String TEXT_44 = "ActionHandler (@NonNull ComponentIdentifier<? extends ";
    protected final String TEXT_45 = "> componentIdentifier) {" + this.NL + "        Validate.notNull(componentIdentifier);" + this.NL + "        return new ";
    protected final String TEXT_46 = "(componentIdentifier);" + this.NL + "    }";
    protected final String TEXT_47 = String.valueOf(this.NL) + "}";

    public static synchronized FactoryGenerator create(String lineSeparator) {
        nl = lineSeparator;
        FactoryGenerator result = new FactoryGenerator();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        CommonGenInfo genInfo = (CommonGenInfo)argument;
        String factoryName = genInfo.getClassName();
        String packageName = genInfo.getClassPackageName();
        Object specInfo = genInfo.getSpecificInformation();
        String fqnGeneratorClassName = this.getClass().getName();
        if (specInfo instanceof FactoryGenInfo) {
            FactoryGenInfo factoryInfo = (FactoryGenInfo)specInfo;
            List<CompInfoForFactoryGen> compInfoList = factoryInfo.getCompInformation();
            String toolkitInfoName = factoryInfo.getToolkitInfoName();
            String toolkitInfoFqName = factoryInfo.getToolkitInfoFqName();
            stringBuffer.append(this.TEXT_1);
            stringBuffer.append(packageName);
            stringBuffer.append(this.TEXT_2);
            if (toolkitInfoFqName != null) {
                stringBuffer.append("import ");
                stringBuffer.append(toolkitInfoFqName);
                stringBuffer.append(";");
            }
            stringBuffer.append(this.TEXT_5);
            stringBuffer.append(genInfo.getToolkitPackageName());
            stringBuffer.append(this.TEXT_6);
            stringBuffer.append(fqnGeneratorClassName);
            stringBuffer.append(this.TEXT_7);
            stringBuffer.append(GenerateUtil.getISO8601Timestamp());
            stringBuffer.append(this.TEXT_8);
            stringBuffer.append(factoryName);
            stringBuffer.append(this.TEXT_9);
            if (toolkitInfoName != null) {
                stringBuffer.append(this.TEXT_10);
                stringBuffer.append(toolkitInfoName);
                stringBuffer.append("Toolkit.createToolkitInformation();");
            }
            stringBuffer.append(this.TEXT_12);
            stringBuffer.append(factoryName);
            stringBuffer.append(this.TEXT_13);
            if (toolkitInfoName != null) {
                stringBuffer.append(this.TEXT_14);
            }
            stringBuffer.append(this.TEXT_15);
            for (CompInfoForFactoryGen compInfo : compInfoList) {
                String componentName = compInfo.getClassName();
                String componentPackageName = compInfo.getPackageName();
                String fqClassName = String.valueOf(componentPackageName) + "." + componentName;
                String fqClassNameActionHandler = String.valueOf(componentPackageName) + ".handler." + componentName + "ActionHandler";
                ComponentClass componentClass = compInfo.getComponentClass();
                String componentClassName = "";
                boolean hasComponentClass = false;
                if (componentClass != null && !componentClass.getName().isEmpty()) {
                    componentClassName = componentClass.getName();
                    hasComponentClass = true;
                }
                String returnType = compInfo.getMostSpecificVisibleSuperTypeName();
                String returnTypeActionHandler = returnType.replaceAll("^(.*\\.)*(.*?)$", "$1handler.$2ActionHandler");
                Boolean hasDefaultMapping = compInfo.hasDefaultMapping();
                String sinceC = "";
                String sinceCVersion = compInfo.getSince();
                if (sinceCVersion != null) {
                    sinceC = "@since " + sinceCVersion;
                }
                if (hasDefaultMapping.booleanValue()) {
                    stringBuffer.append(this.TEXT_16);
                    stringBuffer.append(componentName);
                    stringBuffer.append(this.TEXT_17);
                    stringBuffer.append(sinceC);
                    stringBuffer.append(this.TEXT_18);
                    stringBuffer.append(returnType);
                    stringBuffer.append(" create");
                    stringBuffer.append(componentName);
                    stringBuffer.append(this.TEXT_20);
                    stringBuffer.append(fqClassName);
                    stringBuffer.append(this.TEXT_21);
                } else {
                    stringBuffer.append(this.TEXT_22);
                    if (hasComponentClass) {
                        stringBuffer.append("{@link ");
                        stringBuffer.append(componentClassName);
                        stringBuffer.append("}");
                    } else {
                        stringBuffer.append(componentName);
                    }
                    stringBuffer.append(this.TEXT_25);
                    stringBuffer.append(sinceC);
                    stringBuffer.append(this.TEXT_26);
                    stringBuffer.append(returnType);
                    stringBuffer.append(" create");
                    stringBuffer.append(componentName);
                    stringBuffer.append(" (@NonNull ComponentIdentifier<? extends ");
                    stringBuffer.append(returnType);
                    stringBuffer.append(this.TEXT_29);
                    stringBuffer.append(fqClassName);
                    stringBuffer.append(this.TEXT_30);
                }
                stringBuffer.append(this.TEXT_31);
                String sinceHandler = "@since 4.0";
                try {
                    String[] sinceValues = sinceCVersion.split("\\.");
                    if (sinceValues.length == 2) {
                        if (Integer.parseInt(sinceValues[0]) > 4) {
                            sinceHandler = sinceC;
                        } else if (Integer.parseInt(sinceValues[1]) > 0) {
                            sinceHandler = "@since 4." + sinceValues[1];
                        }
                    }
                }
                catch (Exception exception) {}
                if (hasDefaultMapping.booleanValue()) {
                    stringBuffer.append(this.TEXT_32);
                    stringBuffer.append(componentName);
                    stringBuffer.append(this.TEXT_33);
                    stringBuffer.append(sinceHandler);
                    stringBuffer.append(this.TEXT_34);
                    stringBuffer.append(returnTypeActionHandler);
                    stringBuffer.append(" create");
                    stringBuffer.append(componentName);
                    stringBuffer.append(this.TEXT_36);
                    stringBuffer.append(fqClassNameActionHandler);
                    stringBuffer.append(this.TEXT_37);
                    continue;
                }
                stringBuffer.append(this.TEXT_38);
                if (hasComponentClass) {
                    stringBuffer.append("{@link ");
                    stringBuffer.append(componentClassName);
                    stringBuffer.append("}");
                } else {
                    stringBuffer.append(componentName);
                }
                stringBuffer.append(this.TEXT_41);
                stringBuffer.append(sinceHandler);
                stringBuffer.append(this.TEXT_42);
                stringBuffer.append(returnTypeActionHandler);
                stringBuffer.append(" create");
                stringBuffer.append(componentName);
                stringBuffer.append("ActionHandler (@NonNull ComponentIdentifier<? extends ");
                stringBuffer.append(returnType);
                stringBuffer.append(this.TEXT_45);
                stringBuffer.append(fqClassNameActionHandler);
                stringBuffer.append(this.TEXT_46);
            }
            stringBuffer.append(this.TEXT_47);
        }
        return stringBuffer.toString();
    }
}

