/**
 * File:    ImportTransformationWizard.java
 * Created: 12.12.2008
 *
 *
/*******************************************************************************
 * Copyright (c) 2008  Open Wide (www.openwide.fr)
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Mickael Istria, Open Wide, Lyon, France
 *      - Creation and implementation
 *******************************************************************************/
package org.eclipse.jwt.transformations.importTransformations.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportTransformationWizard extends Wizard implements IImportWizard {

	private TransformationImportWizardPage mainPage;
	private String inFilePath;
	
	@Override
	public boolean performFinish() {
		return mainPage.finish();
	}
	
	@Override
	public void addPages() {
        super.addPages();
       	mainPage = new TransformationImportWizardPage();
       	if (this.inFilePath != null)
       		mainPage.setInFilePath(this.inFilePath);
        addPage(mainPage);
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		Object firstItem = selection.getFirstElement();
		if (firstItem instanceof IFile) {
			this.inFilePath = ((IFile)firstItem).getLocation().toOSString();
		}
	}

}
