/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.providers;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jwt.meta.model.core.NamedElement;
import org.eclipse.jwt.meta.providers.interfaces.IImageProvider;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.figures.internal.CombinedImageDescriptor;
import org.eclipse.jwt.we.figures.internal.ScalingImageDescriptor;
import org.eclipse.jwt.we.misc.views.Views;

public class MetaModelImageProvider
implements IImageProvider {
    private ImageDescriptor createScalingImageDescriptor(ImageDescriptor imageDescriptor) {
        if (imageDescriptor != null) {
            return new ScalingImageDescriptor(imageDescriptor, new Dimension(16, 16));
        }
        return null;
    }

    public ImageDescriptor createImageDescriptor(Object object) {
        String iconPath = "";
        if (!(object instanceof NamedElement) || ((NamedElement)object).getIcon() == null) {
            return this.createScalingImageDescriptor(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createModelTypeImageDescriptor(object));
        }
        iconPath = ((NamedElement)object).getIcon();
        ImageDescriptor urlDescriptor = null;
        ImageDescriptor pluginDescriptor = null;
        ImageDescriptor fileDescriptor = null;
        if (!iconPath.equals("")) {
            try {
                URL url = new URL(iconPath);
                urlDescriptor = ImageDescriptor.createFromURL((URL)url);
            }
            catch (MalformedURLException malformedURLException) {}
            pluginDescriptor = Plugin.getInstance().getFactoryRegistry().getImageFactory(new Object[0]).createImageDescriptor(iconPath);
            if (new File(iconPath).exists()) {
                fileDescriptor = ImageDescriptor.createFromFile(null, (String)iconPath);
            } else if (new File("icons/" + iconPath).exists()) {
                fileDescriptor = ImageDescriptor.createFromFile(null, (String)("icons/" + iconPath));
            }
        }
        if (iconPath.equals("") && pluginDescriptor == null && urlDescriptor == null && fileDescriptor == null) {
            return this.createScalingImageDescriptor(Plugin.getInstance().getFactoryRegistry().getImageFactory(new Object[0]).createModelTypeImageDescriptor(object));
        }
        if (!iconPath.equals("") && pluginDescriptor == null && urlDescriptor == null && fileDescriptor == null) {
            return this.createScalingImageDescriptor(Plugin.getInstance().getFactoryRegistry().getImageFactory(new Object[0]).createModelTypeImageDescriptor(object));
        }
        return this.createScalingImageDescriptor(new CombinedImageDescriptor(new ImageDescriptor[]{urlDescriptor, pluginDescriptor, fileDescriptor}));
    }
}

