/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.helpers.app.changeListener.jarArchive;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jwt.meta.model.application.Application;
import org.eclipse.jwt.we.helpers.app.Messages;
import org.eclipse.jwt.we.helpers.app.jdt.JDTTools;
import org.eclipse.ui.PlatformUI;

public class JarArchiveChangedListener
implements INotifyChangedListener {
    public void notifyChanged(Notification notification) {
        String jarFile = notification.getNewStringValue();
        Application app = (Application)notification.getNotifier();
        this.updateClasspath(jarFile, JDTTools.getJavaProject(app));
    }

    private void updateClasspath(String jarFile, IJavaProject javaProject) {
        if (javaProject == null) {
            return;
        }
        try {
            MessageDialog messageBox;
            int res;
            boolean alreadyInClasspath = false;
            IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 1 && entry.getPath().toString().equals(jarFile)) {
                    alreadyInClasspath = true;
                }
                ++n2;
            }
            if (!alreadyInClasspath && new File(jarFile).exists() && (res = (messageBox = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.addToClassPath_title, null, Messages.addToClassPath_message, 3, new String[]{Messages.no, Messages.yes}, 1)).open()) == 32) {
                IClasspathEntry[] cp = javaProject.getRawClasspath();
                IClasspathEntry[] newCp = new IClasspathEntry[cp.length + 1];
                System.arraycopy(cp, 0, newCp, 0, cp.length);
                Path jarFileIPath = new Path(new File(jarFile).getAbsolutePath());
                newCp[cp.length] = JavaCore.newLibraryEntry((IPath)jarFileIPath, null, null);
                javaProject.setRawClasspath(newCp, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException javaModelException) {}
    }
}

