/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we_view_editor.editors;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.editors.actions.managed.recentfiles.RecentFilesListManager;
import org.eclipse.jwt.we.misc.util.FontUtil;
import org.eclipse.jwt.we.misc.views.ViewEcoreManager;
import org.eclipse.jwt.we.misc.views.ViewItemWrapper;
import org.eclipse.jwt.we_view_editor.PluginProperties;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewEditor
extends MultiPageEditorPart {
    private Composite composite;
    private Table table;
    private List<ViewItemWrapper> itemtabledata = null;
    private List<ViewItemWrapper> attributes = null;
    private File currentfile;
    private String extension = "view";
    private int selectedRow;
    private URL ecorePath = null;
    private Object[][] data;
    private boolean dirty = false;
    private Text viewName;

    protected void createPages() {
        this.composite = new Composite(this.getContainer(), 0);
        int index = this.addPage((Control)this.composite);
        this.setPageText(index, PluginProperties.editor_pagetext_properties);
        this.getPathToFile();
        this.getPathToEcoreFile();
        ViewEcoreManager.getInstance().setPath(this.ecorePath.toString());
        ViewEcoreManager.getInstance().openFile(this.currentfile);
        this.createLayout();
        this.reloadTables();
        ViewEcoreManager.getInstance().savetoFile(this.currentfile);
        ViewEcoreManager.getInstance().setPath(this.ecorePath.getFile());
    }

    private void createLayout() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.composite.setLayout((Layout)layout);
        GridLayout layout2Columns = new GridLayout();
        layout2Columns.numColumns = 2;
        GridData data = new GridData();
        data.verticalAlignment = 1;
        this.createLayoutViewname(layout2Columns);
        GridData data1 = new GridData();
        data1.verticalAlignment = 1;
        data1.verticalAlignment = 4;
        data1.grabExcessVerticalSpace = true;
        data1.grabExcessHorizontalSpace = true;
        this.createLayoutTable(layout2Columns, data1);
    }

    private void createLayoutViewname(GridLayout layout) {
        Group grNames = new Group(this.composite, 0);
        grNames.setText(PluginProperties.editor_group_viewname);
        grNames.setFont(FontUtil.getSystemStyle((int)1));
        grNames.setLayout((Layout)layout);
        GridData data = new GridData();
        grNames.setLayoutData((Object)data);
        Label name = new Label((Composite)grNames, 0);
        name.setText(PluginProperties.editor_fieldname_viewname);
        name.setVisible(true);
        this.viewName = new Text((Composite)grNames, 2048);
        data.horizontalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 1;
        data.widthHint = 335;
        this.viewName.setLayoutData((Object)data);
        this.viewName.setSize(285, 15);
        this.viewName.setText(ViewEcoreManager.getInstance().getName());
        this.viewName.setVisible(true);
        this.viewName.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent arg0) {
                ViewEditor.this.setDirty(true);
            }

            public void keyReleased(KeyEvent arg0) {
                ViewEditor.this.setDirty(true);
            }
        });
        grNames.setVisible(true);
    }

    private void createLayoutTable(GridLayout layout, GridData data) {
        Group grTables = new Group(this.composite, 0);
        grTables.setText(PluginProperties.editor_group_properties);
        grTables.setFont(FontUtil.getSystemStyle((int)1));
        grTables.setLayout((Layout)layout);
        grTables.setLayoutData((Object)data);
        this.table = new Table((Composite)grTables, 68356);
        this.table.setLayoutData((Object)new GridData(0, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setSize(300, 800);
        TableColumn columnProp = new TableColumn(this.table, 0, 0);
        columnProp.setText(PluginProperties.editor_properties_tableColumn);
        columnProp.setWidth(250);
        TableColumn columnAct = new TableColumn(this.table, 0, 1);
        columnAct.setWidth(50);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ViewEditor.this.selectedRow = ViewEditor.this.table.getSelectionIndex();
                ViewItemWrapper obj = (ViewItemWrapper)ViewEditor.this.itemtabledata.get(ViewEditor.this.selectedRow);
                ViewEditor.this.attributes = ViewEcoreManager.getInstance().getAttributesList(obj);
            }
        });
        TableViewer tableviewer = new TableViewer(this.table);
        this.getSite().setSelectionProvider((ISelectionProvider)tableviewer);
    }

    private void getPathToFile() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            FileEditorInput f = (FileEditorInput)this.getEditorInput();
            this.currentfile = new File(f.getPath().toFile().getAbsolutePath());
        } else if (this.getEditorInput() instanceof FileStoreEditorInput) {
            URI fileName = URI.createFileURI((String)((FileStoreEditorInput)this.getEditorInput()).getURI().getPath());
            this.currentfile = new File(fileName.toFileString());
        }
    }

    private void getPathToEcoreFile() {
        org.eclipse.jwt.meta.Plugin plugin = org.eclipse.jwt.meta.Plugin.getDefault();
        Bundle bundle = plugin.getBundle();
        this.ecorePath = bundle.getResource("/org/eclipse/jwt/meta/ecore/JWTMetaModel.ecore");
    }

    private void reloadTables() {
        this.itemtabledata = ViewEcoreManager.getInstance().getItemsList();
        this.data = new Object[this.itemtabledata.size()][2];
        int i = 0;
        while (i < this.itemtabledata.size()) {
            this.data[i][0] = this.itemtabledata.get(i);
            this.data[i][1] = this.itemtabledata.get(i).getValue();
            final int p = i;
            final Button buttonCheck = new Button((Composite)this.table, 32);
            buttonCheck.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ViewEditor.this.setDirty(true);
                    ViewItemWrapper viw = (ViewItemWrapper)ViewEditor.this.data[p][0];
                    boolean value = buttonCheck.getSelection();
                    ViewEcoreManager.getInstance().setDisplay(viw, value);
                }
            });
            TableItem item = new TableItem(this.table, 0);
            TableEditor editor = new TableEditor(this.table);
            editor.grabHorizontal = true;
            editor.minimumHeight = buttonCheck.getSize().x;
            editor.minimumWidth = buttonCheck.getSize().y;
            editor.setEditor((Control)buttonCheck, item, 1);
            item.setText(0, this.data[i][0].toString());
            if (this.data[i][1].equals(true)) {
                buttonCheck.setSelection(true);
            } else {
                buttonCheck.setSelection(false);
            }
            item.setData((Object)buttonCheck);
            ++i;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.firePropertyChange(257);
    }

    public void dispose() {
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        Path path = new Path(this.currentfile.getAbsolutePath());
        String pathtofile = path.makeAbsolute().toFile().getAbsolutePath();
        pathtofile = pathtofile.replace("\\", "/");
        if (this.viewName.getText().length() == 0) {
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)PluginProperties.editor_ErrorMessage_title, (String)PluginProperties.editor_ErrorMissingViewName_message);
            return;
        }
        ViewEcoreManager.getInstance().setName(this.viewName.getText());
        ViewEcoreManager.getInstance().savetoFile(new File(pathtofile));
        this.setDirty(false);
    }

    public void doSaveAs() {
        File file;
        Shell shell = this.getSite().getWorkbenchWindow().getShell();
        if (this.viewName.getText().length() == 0) {
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)PluginProperties.editor_ErrorMessage_title, (String)PluginProperties.editor_ErrorMissingViewName_message);
            return;
        }
        FileDialog fd = new FileDialog(shell, 8192);
        String selectedfile = null;
        try {
            fd.setFileName(this.getEditorInput().getName());
            fd.setFilterExtensions(new String[]{"*." + this.extension});
            selectedfile = fd.open();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (selectedfile == null) {
            return;
        }
        Path path = new Path(selectedfile);
        File file2 = file = path != null ? path.toFile() : null;
        if (file == null) {
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)PluginProperties.editor_ErrorMessage_title, (String)PluginProperties.editor_ErrorSavingFile_message);
            return;
        }
        IWorkbenchPage workbenchPage = Plugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = workbenchPage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            String openFileName = "";
            try {
                openFileName = editorReference.getEditorInput() instanceof URIEditorInput ? ((URIEditorInput)editorReference.getEditorInput()).getURI().toFileString() : (editorReference.getEditorInput() instanceof FileStoreEditorInput ? URI.createFileURI((String)((FileStoreEditorInput)editorReference.getEditorInput()).getURI().getPath()).toFileString() : editorReference.getEditorInput().getName());
            }
            catch (PartInitException partInitException) {}
            if (openFileName.equals(selectedfile)) {
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)PluginProperties.editor_ErrorMessage_title, (String)PluginProperties.editor_ErrorCurrentlyOpen_message);
                return;
            }
            ++n2;
        }
        if (file.exists() && !MessageDialog.openQuestion((Shell)this.getEditorSite().getShell(), (String)PluginProperties.editor_QuestionOverwriteFile_title, (String)PluginProperties.editor_QuestionOverwriteFile_message)) {
            return;
        }
        String pathtofile = path.makeAbsolute().toFile().getAbsolutePath();
        pathtofile = pathtofile.replace("\\", "/");
        ViewEcoreManager.getInstance().setName(this.viewName.getText());
        ViewEcoreManager.getInstance().savetoFile(new File(pathtofile));
        this.setDirty(false);
        if (this.getEditorInput() instanceof URIEditorInput) {
            if (((URIEditorInput)this.getEditorInput()).getURI().toFileString() != null) {
                RecentFilesListManager.getInstance().setNewFile(((URIEditorInput)this.getEditorInput()).getURI().toFileString());
            } else {
                RecentFilesListManager.getInstance().setNewFile(((URIEditorInput)this.getEditorInput()).getURI().toString());
            }
        } else {
            RecentFilesListManager.getInstance().setNewFile(URI.createURI((String)this.getEditorInput().getName()).toFileString());
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        try {
            super.init(site, editorInput);
            this.setPartName(editorInput.getName());
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public ViewItemWrapper getItemtabledata(int selectedRow) {
        return this.itemtabledata.get(selectedRow);
    }

    public List<ViewItemWrapper> getListOfAttributes() {
        return this.attributes;
    }

    public Object getItemValue() {
        return this.data[this.selectedRow][1];
    }

    public URL getEcorePath() {
        return this.ecorePath;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setChangesFromView(Object dataView, boolean value) {
        ViewItemWrapper viw = (ViewItemWrapper)dataView;
        ViewEcoreManager.getInstance().setDisplay(viw, value);
    }
}

