/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.remotese.transport.impl.java;

import org.eclipse.keyple.plugin.remotese.exception.KeypleRemoteException;
import org.eclipse.keyple.plugin.remotese.transport.DtoHandler;
import org.eclipse.keyple.plugin.remotese.transport.KeypleDtoHelper;
import org.eclipse.keyple.plugin.remotese.transport.factory.ClientNode;
import org.eclipse.keyple.plugin.remotese.transport.impl.java.LocalServer;
import org.eclipse.keyple.plugin.remotese.transport.impl.java.LocalTransportDto;
import org.eclipse.keyple.plugin.remotese.transport.model.KeypleDto;
import org.eclipse.keyple.plugin.remotese.transport.model.TransportDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalClient
implements ClientNode {
    private static final Logger logger = LoggerFactory.getLogger(LocalClient.class);
    private final LocalServer theServer;
    private DtoHandler dtoHandler;

    public LocalClient(LocalServer server) {
        this.theServer = server;
    }

    public void onLocalMessage(KeypleDto keypleDto) {
        if (this.dtoHandler == null) {
            throw new IllegalStateException("no DtoHandler defined");
        }
        TransportDto response = this.dtoHandler.onDTO(new LocalTransportDto(keypleDto, this));
        this.sendDTO(response);
    }

    @Override
    public void setDtoHandler(DtoHandler handler) {
        this.dtoHandler = handler;
    }

    @Override
    public void sendDTO(TransportDto transportDto) {
        if (KeypleDtoHelper.isNoResponse(transportDto.getKeypleDTO()).booleanValue()) {
            logger.trace("Keyple DTO is empty, do not send it");
        } else {
            this.theServer.onLocalMessage(transportDto);
        }
    }

    @Override
    public void sendDTO(KeypleDto keypleDto) throws KeypleRemoteException {
        if (this.theServer == null) {
            throw new KeypleRemoteException("Unable to connect to server");
        }
        if (KeypleDtoHelper.isNoResponse(keypleDto).booleanValue()) {
            logger.trace("Keyple DTO is empty, do not send it");
        } else {
            this.theServer.onLocalMessage(new LocalTransportDto(keypleDto, this));
        }
    }

    @Override
    public String getNodeId() {
        return "localClient1";
    }

    @Override
    public void connect(ClientNode.ConnectCallback connectCallback) {
        if (connectCallback != null) {
            logger.warn("Connection callback is not implemented for this client");
        }
        logger.info("Connect Local Client");
    }

    @Override
    public void disconnect() {
        logger.info("Disconnect Local Client");
    }
}

