/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.stub;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.keyple.plugin.stub.StubSecureElement;
import org.eclipse.keyple.seproxy.exception.KeypleChannelStateException;
import org.eclipse.keyple.seproxy.exception.KeypleIOReaderException;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.exception.NoStackTraceThrowable;
import org.eclipse.keyple.seproxy.message.ApduRequest;
import org.eclipse.keyple.seproxy.message.ApduResponse;
import org.eclipse.keyple.seproxy.message.SeRequestSet;
import org.eclipse.keyple.seproxy.message.SeResponseSet;
import org.eclipse.keyple.seproxy.plugin.AbstractThreadedLocalReader;
import org.eclipse.keyple.seproxy.protocol.Protocol;
import org.eclipse.keyple.seproxy.protocol.SeProtocol;
import org.eclipse.keyple.seproxy.protocol.TransmissionMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StubReader
extends AbstractThreadedLocalReader {
    private static final Logger logger = LoggerFactory.getLogger(StubReader.class);
    private StubSecureElement se;
    private boolean sePresent;
    private Map<String, String> parameters = new HashMap<String, String>();
    public static final String ALLOWED_PARAMETER_1 = "parameter1";
    public static final String ALLOWED_PARAMETER_2 = "parameter2";
    public static final String CONTACTLESS_PARAMETER = "contactless";
    public static final String CONTACTS_PARAMETER = "contacts";
    static final String pluginName = "StubPlugin";
    String readerName = "StubReader";
    TransmissionMode transmissionMode = TransmissionMode.CONTACTLESS;

    public StubReader(String name) {
        super(pluginName, name);
        this.readerName = name;
        this.sePresent = false;
        this.threadWaitTimeout = 5000L;
    }

    protected byte[] getATR() {
        return this.se.getATR();
    }

    protected boolean isPhysicalChannelOpen() {
        return this.se != null && this.se.isPhysicalChannelOpen();
    }

    protected void openPhysicalChannel() throws KeypleChannelStateException {
        if (this.se != null) {
            this.se.openPhysicalChannel();
        }
    }

    public void closePhysicalChannel() throws KeypleChannelStateException {
        if (this.se != null) {
            this.se.closePhysicalChannel();
        }
    }

    public byte[] transmitApdu(byte[] apduIn) throws KeypleIOReaderException {
        return this.se.processApdu(apduIn);
    }

    protected boolean protocolFlagMatches(SeProtocol protocolFlag) throws KeypleReaderException {
        boolean result;
        if (protocolFlag != Protocol.ANY) {
            String protocol;
            String selectionMask;
            if (!this.isPhysicalChannelOpen()) {
                this.openPhysicalChannel();
            }
            if ((selectionMask = (String)this.protocolsMap.get(protocolFlag)) == null) {
                throw new KeypleReaderException("Target selector mask not found!", null);
            }
            Pattern p = Pattern.compile(selectionMask);
            if (!p.matcher(protocol = this.se.getSeProcotol()).matches()) {
                logger.trace("[{}] protocolFlagMatches => unmatching SE. PROTOCOLFLAG = {}", (Object)this.getName(), (Object)protocolFlag);
                result = false;
            } else {
                logger.trace("[{}] protocolFlagMatches => matching SE. PROTOCOLFLAG = {}", (Object)this.getName(), (Object)protocolFlag);
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    protected boolean checkSePresence() {
        return this.se != null;
    }

    public void setParameter(String name, String value) throws KeypleReaderException {
        if (name.equals(ALLOWED_PARAMETER_1) || name.equals(ALLOWED_PARAMETER_2)) {
            this.parameters.put(name, value);
        } else if (name.equals(CONTACTS_PARAMETER)) {
            this.transmissionMode = TransmissionMode.CONTACTS;
        } else if (name.equals(CONTACTLESS_PARAMETER)) {
            this.transmissionMode = TransmissionMode.CONTACTLESS;
        } else {
            throw new KeypleReaderException("parameter name not supported : " + name);
        }
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public TransmissionMode getTransmissionMode() {
        return this.transmissionMode;
    }

    final ApduResponse processApduRequestTestProxy(ApduRequest apduRequest) throws KeypleReaderException {
        return this.processApduRequest(apduRequest);
    }

    final SeResponseSet processSeRequestSetTestProxy(SeRequestSet requestSet) throws KeypleReaderException {
        return this.processSeRequestSet(requestSet);
    }

    final boolean isLogicalChannelOpenTestProxy() {
        return this.isPhysicalChannelOpen();
    }

    public void insertSe(StubSecureElement _se) {
        if (this.isPhysicalChannelOpen()) {
            try {
                this.closePhysicalChannel();
            }
            catch (KeypleReaderException e) {
                e.printStackTrace();
            }
        }
        this.se = _se;
        this.sePresent = true;
    }

    public void removeSe() {
        this.se = null;
        this.sePresent = false;
    }

    protected boolean waitForCardPresent(long timeout) throws NoStackTraceThrowable {
        int i = 0;
        while ((long)i < timeout / 10L && !this.sePresent) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                logger.debug("Sleep was interrupted");
            }
            ++i;
        }
        return this.sePresent;
    }

    protected boolean waitForCardAbsent(long timeout) throws NoStackTraceThrowable {
        int i = 0;
        while ((long)i < timeout / 10L && this.sePresent) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                logger.debug("Sleep was interrupted");
            }
            ++i;
        }
        return !this.sePresent;
    }
}

