/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.stub;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.keyple.seproxy.exception.KeypleChannelStateException;
import org.eclipse.keyple.seproxy.exception.KeypleIOReaderException;
import org.eclipse.keyple.util.ByteArrayUtils;

public abstract class StubSecureElement {
    boolean isPhysicalChannelOpen = false;
    Map<String, String> hexCommands = new HashMap<String, String>();

    public abstract byte[] getATR();

    public boolean isPhysicalChannelOpen() {
        return this.isPhysicalChannelOpen;
    }

    public void openPhysicalChannel() throws KeypleChannelStateException {
        this.isPhysicalChannelOpen = true;
    }

    public void closePhysicalChannel() throws KeypleChannelStateException {
        this.isPhysicalChannelOpen = false;
    }

    public abstract String getSeProcotol();

    public void addHexCommand(String command, String response) {
        assert (command != null && response != null) : "command and response should not be null";
        this.hexCommands.put(command.replace(" ", ""), response.replace(" ", ""));
    }

    public void removeHexCommand(String command) {
        assert (command != null) : "command should not be null";
        this.hexCommands.remove(command.trim());
    }

    public byte[] processApdu(byte[] apduIn) throws KeypleIOReaderException {
        if (apduIn == null) {
            return null;
        }
        String hexApdu = ByteArrayUtils.toHex((byte[])apduIn);
        if (this.hexCommands.containsKey(hexApdu)) {
            return ByteArrayUtils.fromHex((String)this.hexCommands.get(hexApdu));
        }
        throw new KeypleIOReaderException("No response available for this request.");
    }
}

