/*******************************************************************************
 * Copyright (c) 2009, 2011 SpringSource, a divison of VMware, Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SpringSource, a division of VMware, Inc. - initial API and implementation
 *     SAP AG - moving to Eclipse Libra project and enhancements
 *******************************************************************************/
package org.eclipse.libra.framework.editor.integration.internal.admin.osgijmx;

import org.eclipse.libra.framework.editor.core.model.IPackageImport;

/**
 * @author Christian Dupuis
 * @author Kaloyan Raev
 */
public class PackageImport implements IPackageImport {

	private final String name;

	private final String version;

	private final String supplierId;

	public PackageImport(String name, String version, String supplierId) {
		this.name = name;
		this.version = version;
		this.supplierId = supplierId;
	}

	public String getName() {
		return name;
	}

	public String getVersion() {
		return version;
	}

	public String getSupplierId() {
		return supplierId;
	}
	
	@Override
	public int hashCode() {
		int hashCode = 17;
		hashCode = 31 * hashCode + name.hashCode();
		hashCode = 31 * hashCode + version.hashCode();
		hashCode = 31 * hashCode + supplierId.hashCode();
		return hashCode;
	}
	
	@Override
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (!(other instanceof PackageImport)) {
			return false;
		}
		PackageImport that = (PackageImport) other;
		if (this.name != that.name) {
			return false;
		}
		if (this.name != null && !this.name.equals(that.name)) {
			return false;
		}
		if (this.version != that.version) {
			return false;
		}
		if (this.version != null && !this.version.equals(that.version)) {
			return false;
		}
		if (this.supplierId != that.supplierId) {
			return false;
		}
		if (this.supplierId != null && !this.supplierId.equals(that.supplierId)) {
			return false;
		}
		return true;
	}
	

}
