/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.lsp4e.ContentTypeToLSPLaunchConfigEntry;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.enablement.EnablementTester;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.ui.EnableDisableLSJob;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.NewContentTypeLSPLaunchDialog;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class LanguageServerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final LanguageServersRegistry registry = LanguageServersRegistry.getInstance();
    private List<ContentTypeToLSPLaunchConfigEntry> workingCopy = (List)NullSafetyHelper.lateNonNull();
    private Button removeButton = (Button)NullSafetyHelper.lateNonNull();
    private CheckboxTableViewer checkboxViewer = (CheckboxTableViewer)NullSafetyHelper.lateNonNull();
    private TableViewer viewer = (TableViewer)NullSafetyHelper.lateNonNull();
    private final SelectionAdapter contentTypeLinkListener;
    private final List<ContentTypeToLanguageServerDefinition> changedDefinitions = new ArrayList<ContentTypeToLanguageServerDefinition>();

    public LanguageServerPreferencePage() {
        this.contentTypeLinkListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPreferencePageContainer iPreferencePageContainer = LanguageServerPreferencePage.this.getContainer();
                if (iPreferencePageContainer instanceof IWorkbenchPreferenceContainer) {
                    IWorkbenchPreferenceContainer preferenceContainer = (IWorkbenchPreferenceContainer)iPreferencePageContainer;
                    preferenceContainer.openPage("org.eclipse.ui.preferencePages.ContentTypes", null);
                }
            }
        };
    }

    public void init(IWorkbench workbench) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.checkboxViewer.refresh();
        }
    }

    protected Control createContents(Composite parent) {
        Composite res = new Composite(parent, 0);
        res.setLayout((Layout)new GridLayout(2, false));
        Link intro = new Link(res, 64);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).span(2, 1).hint(400, -1).applyTo((Control)intro);
        intro.setText(Messages.PreferencesPage_Intro);
        intro.addSelectionListener((SelectionListener)this.contentTypeLinkListener);
        this.createStaticServersTable(res);
        Link manualServersIntro = new Link(res, 64);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).span(2, 1).hint(400, -1).applyTo((Control)manualServersIntro);
        manualServersIntro.setText(Messages.PreferencesPage_manualServers);
        manualServersIntro.addSelectionListener((SelectionListener)this.contentTypeLinkListener);
        this.viewer = new TableViewer(res);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.workingCopy = new ArrayList<ContentTypeToLSPLaunchConfigEntry>();
        this.workingCopy.addAll(LanguageServersRegistry.getInstance().getContentTypeToLSPLaunches());
        TableViewerColumn contentTypeColumn = new TableViewerColumn(this.viewer, 0);
        contentTypeColumn.getColumn().setText(Messages.PreferencesPage_contentType);
        contentTypeColumn.getColumn().setWidth(200);
        contentTypeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IContentType)((ContentTypeToLanguageServerDefinition)element).getKey()).getName();
            }
        });
        TableViewerColumn launchConfigColumn = new TableViewerColumn(this.viewer, 0);
        launchConfigColumn.getColumn().setText(Messages.PreferencesPage_LaunchConfiguration);
        launchConfigColumn.getColumn().setWidth(300);
        launchConfigColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ContentTypeToLSPLaunchConfigEntry)element).getLaunchConfiguration().getName();
            }
        });
        TableViewerColumn launchModeColumn = new TableViewerColumn(this.viewer, 0);
        launchModeColumn.getColumn().setText(Messages.PreferencesPage_LaunchMode);
        launchModeColumn.getColumn().setWidth(100);
        launchModeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                StringBuilder res = new StringBuilder();
                for (String s : ((ContentTypeToLSPLaunchConfigEntry)element).getLaunchModes()) {
                    res.append(s);
                    res.append(',');
                }
                if (res.length() > 0) {
                    res.deleteCharAt(res.length() - 1);
                }
                return res.toString();
            }
        });
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.getTable().setHeaderVisible(true);
        Composite buttonComposite = new Composite(res, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setLayoutData((Object)new GridData(4, 0, true, false));
        addButton.setText(Messages.PreferencesPage_Add);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewContentTypeLSPLaunchDialog dialog = new NewContentTypeLSPLaunchDialog(LanguageServerPreferencePage.this.getShell());
                if (dialog.open() == 0) {
                    LanguageServerPreferencePage.this.workingCopy.add(new ContentTypeToLSPLaunchConfigEntry(dialog.getContentType(), dialog.getLaunchConfiguration(), dialog.getLaunchMode()));
                    LanguageServerPreferencePage.this.viewer.refresh();
                }
                super.widgetSelected(e);
            }
        });
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setLayoutData((Object)new GridData(4, 0, true, false));
        this.removeButton.setText(Messages.PreferencesPage_Remove);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection sel = LanguageServerPreferencePage.this.viewer.getSelection();
                if (!sel.isEmpty() && sel instanceof IStructuredSelection) {
                    IStructuredSelection structuredSel = (IStructuredSelection)sel;
                    structuredSel.forEach(LanguageServerPreferencePage.this.workingCopy::remove);
                    LanguageServerPreferencePage.this.viewer.refresh();
                }
            }
        });
        this.viewer.addSelectionChangedListener(event -> this.updateButtons());
        this.viewer.setInput(this.workingCopy);
        this.updateButtons();
        return res;
    }

    private void createStaticServersTable(Composite res) {
        Link staticServersIntro = new Link(res, 64);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).span(2, 1).hint(400, -1).applyTo((Control)staticServersIntro);
        staticServersIntro.setText(Messages.PreferencesPage_staticServers);
        staticServersIntro.addSelectionListener((SelectionListener)this.contentTypeLinkListener);
        this.checkboxViewer = CheckboxTableViewer.newCheckList((Composite)res, (int)0);
        this.checkboxViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.checkboxViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn enablementColumn = new TableViewerColumn((TableViewer)this.checkboxViewer, 0);
        enablementColumn.getColumn().setText(Messages.PreferencesPage_Enabled);
        enablementColumn.getColumn().setWidth(70);
        enablementColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public @Nullable String getText(Object element) {
                return null;
            }
        });
        TableViewerColumn contentTypeColumn = new TableViewerColumn((TableViewer)this.checkboxViewer, 0);
        contentTypeColumn.getColumn().setText(Messages.PreferencesPage_contentType);
        contentTypeColumn.getColumn().setWidth(200);
        contentTypeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IContentType)((ContentTypeToLanguageServerDefinition)element).getKey()).getName();
            }
        });
        TableViewerColumn launchConfigColumn = new TableViewerColumn((TableViewer)this.checkboxViewer, 0);
        launchConfigColumn.getColumn().setText(Messages.PreferencesPage_languageServer);
        launchConfigColumn.getColumn().setWidth(300);
        launchConfigColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((LanguageServersRegistry.LanguageServerDefinition)((ContentTypeToLanguageServerDefinition)element).getValue()).label;
            }
        });
        List<ContentTypeToLanguageServerDefinition> contentTypeToLanguageServerDefinitions = this.registry.getContentTypeToLSPExtensions();
        if (contentTypeToLanguageServerDefinitions.stream().anyMatch(definition -> definition.getEnablementCondition() != null)) {
            TableViewerColumn conditionColumn = new TableViewerColumn((TableViewer)this.checkboxViewer, 0);
            conditionColumn.getColumn().setText(Messages.PreferencesPage_enablementCondition);
            conditionColumn.getColumn().setWidth(150);
            conditionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    EnablementTester tester = ((ContentTypeToLanguageServerDefinition)element).getEnablementCondition();
                    if (tester == null) {
                        return Action.removeMnemonics((String)IDialogConstants.NO_LABEL);
                    }
                    String extensionStatus = ((ContentTypeToLanguageServerDefinition)element).isExtensionEnabled(null) ? Messages.PreferencePage_enablementCondition_true : Messages.PreferencePage_enablementCondition_false;
                    return tester.getDescription() + " (" + extensionStatus + ")";
                }

                public @Nullable Color getBackground(Object element) {
                    EnablementTester tester = ((ContentTypeToLanguageServerDefinition)element).getEnablementCondition();
                    if (tester == null) {
                        return null;
                    }
                    Color red = Display.getDefault().getSystemColor(3);
                    Color green = Display.getDefault().getSystemColor(5);
                    return ((ContentTypeToLanguageServerDefinition)element).isExtensionEnabled(null) ? green : red;
                }
            });
        }
        this.checkboxViewer.setInput(contentTypeToLanguageServerDefinitions);
        this.checkboxViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.checkboxViewer.getTable().setHeaderVisible(true);
        this.checkboxViewer.getTable().setLinesVisible(true);
        this.checkboxViewer.setCheckedElements(contentTypeToLanguageServerDefinitions.stream().filter(ContentTypeToLanguageServerDefinition::isUserEnabled).toArray());
        this.checkboxViewer.addCheckStateListener(event -> {
            Object object = event.getElement();
            if (object instanceof ContentTypeToLanguageServerDefinition) {
                ContentTypeToLanguageServerDefinition contentTypeToLanguageServerDefinition = (ContentTypeToLanguageServerDefinition)object;
                contentTypeToLanguageServerDefinition.setUserEnabled(event.getChecked());
                this.changedDefinitions.add(contentTypeToLanguageServerDefinition);
            }
        });
    }

    protected void updateButtons() {
        this.removeButton.setEnabled(!this.viewer.getSelection().isEmpty());
    }

    public boolean performOk() {
        this.registry.setAssociations(this.workingCopy);
        EnableDisableLSJob enableDisableLSJob = new EnableDisableLSJob(this.changedDefinitions, this.getEditors());
        enableDisableLSJob.schedule();
        return super.performOk();
    }

    private IEditorReference @Nullable [] getEditors() {
        IWorkbenchPage page = UI.getActivePage();
        if (page != null) {
            return page.getEditorReferences();
        }
        return null;
    }
}

