/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.ui.util.CDAUIUtil;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.osgi.framework.Bundle;

public class GenerateSampleInstanceAction
implements IObjectActionDelegate {
    protected IWorkbenchPart activePart;
    protected ISelection currentSelection;
    protected Class selectedElement;

    private void createInstance() throws IOException, CoreException {
        URI u;
        String[] segments;
        IWorkspace workspace;
        IWorkspaceRoot root;
        IFile file;
        if (this.selectedElement != null && this.selectedElement.eContainer() != null && this.selectedElement.eContainer().eResource() != null && (file = (root = (workspace = ResourcesPlugin.getWorkspace()).getRoot()).getProject((segments = (u = this.selectedElement.eContainer().eResource().getURI()).segments())[1]).getFolder(segments[2]).getFile(segments[3])) != null && file.exists()) {
            ByteArrayInputStream inputStream;
            ByteArrayOutputStream out;
            Manifest projectManifest;
            Attributes attributes;
            String requiredBundles;
            int index = segments[1].lastIndexOf(".model");
            String generateProjectLocation = index < 0 ? segments[1] : segments[1].substring(0, index);
            IProject generateProject = root.getProject(generateProjectLocation);
            boolean neededCore = false;
            if (generateProject.exists() && generateProject.isOpen() && !(requiredBundles = (attributes = (projectManifest = new Manifest(CDAUIUtil.getManifest(generateProject).getContents())).getMainAttributes()).getValue("Require-Bundle")).contains("org.eclipse.mdht.uml.cda.core")) {
                neededCore = true;
                attributes.putValue("Require-Bundle", String.valueOf(attributes.getValue("Require-Bundle")) + ",org.eclipse.mdht.uml.cda.core");
                out = new ByteArrayOutputStream();
                projectManifest.write(out);
                inputStream = new ByteArrayInputStream(out.toByteArray());
                CDAUIUtil.getManifest(generateProject).setContents((InputStream)inputStream, true, true, null);
            }
            if (index >= 0 && generateProject.exists() && generateProject.isOpen()) {
                ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
                try {
                    ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, "generateXML");
                    workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.mdht.uml.cda.core.internal.generate.Generate");
                    String cdaGenerateArguments = String.format(" \"%s\" \"%s\" \"%s\" \"%s\" ", file.getRawLocation().toOSString(), this.selectedElement.getName(), this.getFormattedResourceLocation("org.eclipse.uml2.uml.resources"), this.getFormattedResourceLocation("org.eclipse.mdht.uml.cda.resources"));
                    workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, cdaGenerateArguments);
                    workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, generateProject.getName());
                    workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
                    workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS", true);
                    workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
                    workingCopy.launch("run", null);
                    workingCopy.doSave();
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            }
            if (neededCore) {
                projectManifest = new Manifest(CDAUIUtil.getManifest(generateProject).getContents());
                attributes = projectManifest.getMainAttributes();
                requiredBundles = attributes.getValue("Require-Bundle");
                attributes.putValue("Require-Bundle", requiredBundles.replace(",org.eclipse.mdht.uml.cda.core", ""));
                out = new ByteArrayOutputStream();
                projectManifest.write(out);
                inputStream = new ByteArrayInputStream(out.toByteArray());
                CDAUIUtil.getManifest(generateProject).setContents((InputStream)inputStream, true, true, null);
            }
        }
    }

    private MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    private URL getURLFromSymbolicName(String symbolicName) {
        try {
            Bundle bundle = Platform.getBundle((String)symbolicName);
            URL url = bundle.getEntry("/");
            url = FileLocator.resolve((URL)url);
            return url;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String getFormattedResourceLocation(String resource) {
        URL fileURL = this.getURLFromSymbolicName(resource);
        return fileURL.toExternalForm();
    }

    protected View getSelectedView() {
        for (Object element : (IStructuredSelection)this.currentSelection) {
            View view = (View)((IAdaptable)element).getAdapter(View.class);
            if (view == null) continue;
            return view;
        }
        return null;
    }

    public void run(IAction action) {
        try {
            this.createInstance();
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
        this.selectedElement = null;
        if (((IStructuredSelection)selection).size() == 1) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof IAdaptable) {
                selected = ((IAdaptable)selected).getAdapter(EObject.class);
            }
            if (selected instanceof View) {
                selected = ((View)selected).getElement();
            }
            if (selected instanceof Class) {
                this.selectedElement = (Class)selected;
            }
        }
        if (this.selectedElement != null) {
            if (CDAProfileUtil.getAppliedCDAProfile((Element)this.selectedElement) != null || CDAModelUtil.getCDAClass((Classifier)this.selectedElement) != null) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
        } else {
            action.setEnabled(false);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }
}

