/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.mdht.uml.common.util.NamedElementComparator;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

public class PropertyList {
    private Class clazz;
    private List<Property> attributes;
    private List<Property> associationEnds;
    private boolean isOmitAssociations = false;
    private boolean isAllSuperclasses = true;
    private boolean isSorted = true;

    public PropertyList(Class clazz) {
        this.clazz = clazz;
    }

    public List<Property> getAttributes() {
        if (this.attributes == null) {
            this.fillPropertyLists();
        }
        return this.attributes;
    }

    public List<Property> getAssociationEnds() {
        if (this.associationEnds == null) {
            this.fillPropertyLists();
        }
        return this.associationEnds;
    }

    public Property getForName(String name) {
        if (name != null) {
            for (Property property : this.getAttributes()) {
                if (!name.equals(property.getName())) continue;
                return property;
            }
            for (Property property : this.getAssociationEnds()) {
                if (!name.equals(property.getName())) continue;
                return property;
            }
        }
        return null;
    }

    private void fillPropertyLists() {
        this.attributes = new ArrayList<Property>();
        this.associationEnds = new ArrayList<Property>();
        this.addProperties(this.clazz);
        if (this.isSorted) {
            Collections.sort(this.attributes, new NamedElementComparator());
            Collections.sort(this.associationEnds, new NamedElementComparator());
        }
    }

    private void addProperties(Class aClass) {
        for (Property property : aClass.getOwnedAttributes()) {
            if (property.getAssociation() != null && (this.isOmitAssociations || "cda".equals(UMLUtil.getTopPackage((Element)aClass).getName())) || "templateId".equals(property.getName()) || this.getForName(property.getName()) != null) continue;
            if (property.getAssociation() == null) {
                this.attributes.add(property);
                continue;
            }
            this.associationEnds.add(property);
        }
        if (this.isAllSuperclasses) {
            for (Classifier general : aClass.getGenerals()) {
                if (!(general instanceof Class)) continue;
                this.addProperties((Class)general);
            }
        }
    }
}

