/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mdht.uml.common.ui.dialogs.DialogLaunchUtil;
import org.eclipse.mdht.uml.common.ui.dialogs.SubclassHandler;
import org.eclipse.mdht.uml.common.ui.search.GeneralizationTypeFilter;
import org.eclipse.mdht.uml.common.ui.search.IElementFilter;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.ui.actions.UML2AbstractAction;
import org.eclipse.mdht.uml.ui.internal.Logger;
import org.eclipse.mdht.uml.ui.internal.l10n.UML2UIMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;

public class AddUMLClassAction
extends UML2AbstractAction {
    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (this.isReadOnly()) {
            action.setEnabled(false);
        }
    }

    protected String getClassName() {
        String className = null;
        InputDialog inputDialog = new InputDialog(this.activePart.getSite().getShell(), "New Class", "Enter class name", "", null);
        if (inputDialog.open() == 0) {
            className = inputDialog.getValue();
        }
        return className;
    }

    protected Class selectSuperClass(Class newClass) {
        Class superClass = (Class)DialogLaunchUtil.chooseElement((IElementFilter)new GeneralizationTypeFilter((Classifier)newClass), (Package)UMLUtil.getTopPackage((Element)newClass), (Shell)this.activePart.getSite().getShell(), (String)"Class Selection", (String)"Select base class (Cancel for none):");
        return superClass;
    }

    protected void addProperties(Class newClass, Class superClass) {
        if (superClass != null) {
            SubclassHandler subclassHandler = new SubclassHandler(this.activePart.getSite().getShell(), newClass);
            subclassHandler.openSubclassDialog();
        }
    }

    protected void postProcess(Class newClass) {
    }

    public void run(IAction action) {
        try {
            final Element element = this.getSelectedElement();
            if (element != null) {
                AbstractEMFOperation operation = new AbstractEMFOperation(this.editingDomain, UML2UIMessages.AddUMLClass_operation_title){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                        String className = AddUMLClassAction.this.getClassName();
                        if (className == null || className.length() == 0) {
                            return Status.CANCEL_STATUS;
                        }
                        Class newClass = UMLFactory.eINSTANCE.createClass();
                        newClass.setName(className);
                        if (element instanceof Package) {
                            ((Package)element).getOwnedTypes().add((Object)newClass);
                        } else if (element instanceof Class) {
                            ((Class)element).getNestedClassifiers().add((Object)newClass);
                        }
                        Class superClass = AddUMLClassAction.this.selectSuperClass(newClass);
                        if (superClass != null) {
                            newClass.createGeneralization((Classifier)superClass);
                        }
                        AddUMLClassAction.this.addProperties(newClass, superClass);
                        AddUMLClassAction.this.postProcess(newClass);
                        if (AddUMLClassAction.this.activePart instanceof ISetSelectionTarget) {
                            ((ISetSelectionTarget)AddUMLClassAction.this.activePart).selectReveal((ISelection)new StructuredSelection((Object)newClass));
                        }
                        return Status.OK_STATUS;
                    }
                };
                try {
                    IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)this.editingDomain.getCommandStack();
                    operation.addContext(commandStack.getDefaultUndoContext());
                    commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), (IAdaptable)this.activePart);
                }
                catch (ExecutionException ee) {
                    Logger.logException(ee);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

