/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.ui.saveable;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mdht.uml.common.ui.internal.Logger;
import org.eclipse.mdht.uml.common.ui.internal.l10n.Messages;
import org.eclipse.mdht.uml.common.ui.saveable.ModelManager;
import org.eclipse.ui.Saveable;

public class ModelDocument
extends Saveable {
    private Resource resource;
    private TransactionalEditingDomain editingDomain;
    private boolean dirty = false;
    private ResourceSetListenerImpl domainDirtyListener;

    public ModelDocument(final Resource resource, TransactionalEditingDomain domain) {
        this.resource = resource;
        this.editingDomain = domain;
        Assert.isNotNull((Object)resource);
        this.domainDirtyListener = new ResourceSetListenerImpl(NotificationFilter.NOT_TOUCH){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                for (Notification notification : event.getNotifications()) {
                    Object notifier = notification.getNotifier();
                    if (notifier instanceof EObject && resource == ((EObject)notifier).eResource()) {
                        ModelDocument.this.setDirty(true);
                        continue;
                    }
                    if (!(notifier instanceof Resource) || resource != notifier || 3 != notification.getFeatureID(null)) continue;
                    ModelDocument.this.setDirty(resource.isModified());
                }
            }
        };
        this.editingDomain.addResourceSetListener((ResourceSetListener)this.domainDirtyListener);
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void doSave(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.ModelSave_task, 1);
        this.dirty = false;
        this.saveResource(monitor);
        this.resource.setModified(false);
        monitor.done();
    }

    public void doClose(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.ModelClose_task, 1);
        this.resource.setModified(false);
        this.dirty = false;
        this.closeResource(monitor);
        monitor.done();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ModelDocument) {
            return this.resource.equals(((ModelDocument)((Object)object)).resource);
        }
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.resource.getURI().lastSegment();
    }

    public String getToolTipText() {
        return this.resource.getURI().toString();
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.resource.setModified(dirty);
    }

    public IFile getFile() {
        IResource iResource;
        if (this.resource != null && (iResource = this.getIResource(this.resource)) instanceof IFile) {
            return (IFile)iResource;
        }
        return null;
    }

    private IResource getIResource(Resource resource) {
        URI uri;
        if (resource != null && (uri = resource.getURI()) != null) {
            if (uri.isPlatformResource()) {
                Path path = new Path(URI.decode((String)uri.path()));
                return ResourcesPlugin.getWorkspace().getRoot().findMember(path.removeFirstSegments(1));
            }
            return ResourcesPlugin.getWorkspace().getRoot().findMember(uri.toString());
        }
        return null;
    }

    private void saveResource(IProgressMonitor monitor) {
        try {
            ModelManager.getManager().getSavedResources().add(this.resource);
            this.resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    private void closeResource(IProgressMonitor monitor) {
        ModelManager.getManager().getChangedResources().remove(this.resource);
        this.resource.unload();
    }
}

