/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.navigator.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.mdht.uml.common.ui.saveable.ModelDocument;
import org.eclipse.mdht.uml.common.ui.saveable.ModelManager;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.common.edit.command.ChangeCommand;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class DeleteUMLAction
extends CommandActionHandler {
    protected List<Element> elements;

    public DeleteUMLAction(EditingDomain domain) {
        super(domain, EMFEditUIPlugin.INSTANCE.getString("_UI_Delete_menu_item"));
    }

    public DeleteUMLAction(EditingDomain domain, String label) {
        super(domain, label);
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
    }

    public Command createCommand(Collection<?> selection) {
        this.elements = new ArrayList<Element>();
        for (Object object : selection) {
            if (!(object instanceof Element) || ((Element)object).getOwner() == null) continue;
            if (object instanceof Class) {
                Class umlClass = (Class)object;
                this.addAssociations(umlClass, this.elements);
                this.elements.add((Element)umlClass);
                continue;
            }
            if (object instanceof Association) {
                Association association = (Association)object;
                this.elements.addAll((Collection<Element>)association.getMemberEnds());
                this.elements.add((Element)association);
                continue;
            }
            this.elements.add((Element)object);
        }
        if (this.elements.size() > 0) {
            return IdentityCommand.INSTANCE;
        }
        return UnexecutableCommand.INSTANCE;
    }

    private void addAssociations(Class umlClass, List<Element> elements) {
        for (Association association : umlClass.getAssociations()) {
            if (elements.contains(association)) continue;
            elements.addAll((Collection<Element>)association.getMemberEnds());
            elements.add((Element)association);
        }
        for (Classifier classifier : umlClass.getNestedClassifiers()) {
            if (!(classifier instanceof Class)) continue;
            this.addAssociations((Class)classifier, elements);
        }
    }

    public void run() {
        if (this.command != UnexecutableCommand.INSTANCE) {
            String label;
            String string = label = this.elements.get(0) instanceof NamedElement && ((NamedElement)this.elements.get(0)).getName() != null ? "Delete " + ((NamedElement)this.elements.get(0)).getName() : "Delete Element";
            if (this.elements.size() > 1) {
                label = String.valueOf(label) + " (+" + (this.elements.size() - 1) + ")";
            }
            this.domain.getCommandStack().execute((Command)new ChangeCommand(this.domain, new Runnable(){

                @Override
                public void run() {
                    for (Element element : DeleteUMLAction.this.elements) {
                        ModelDocument sourceDocument;
                        if (element.eResource() != null && (sourceDocument = ModelManager.getManager().manage(element.eResource())) != null) {
                            sourceDocument.setDirty(true);
                        }
                        element.destroy();
                    }
                }
            }, label));
        }
    }
}

