/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.navigator.internal;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeLightweightDecorator
implements ILightweightLabelDecorator {
    public void decorate(Object object, IDecoration decoration) {
        Element element = null;
        if (object instanceof Element) {
            element = (Element)object;
        } else if (object instanceof IAdaptable) {
            element = (Element)((IAdaptable)object).getAdapter(Element.class);
        }
        if (element != null && !element.getAppliedStereotypes().isEmpty()) {
            StringBuilder decorator = new StringBuilder();
            for (Stereotype stereotype : element.getAppliedStereotypes()) {
                boolean suppressed;
                EAnnotation extensions = stereotype.getEAnnotation("uml2.extensions");
                boolean bl = suppressed = extensions != null && extensions.getDetails() != null && "true".equals(extensions.getDetails().get((Object)"suppressed"));
                if (suppressed) continue;
                if (decorator.length() == 0) {
                    decorator.append("<<");
                } else {
                    decorator.append(", ");
                }
                decorator.append(stereotype.getKeyword());
            }
            if (decorator.length() > 0) {
                decorator.append(">> ");
                decoration.addPrefix(decorator.toString());
            }
        }
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

