/*
 * Decompiled with CFR 0.152.
 */
package traceability.util;

import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import traceability.LogEntry;
import traceability.Trace;
import traceability.TraceabilityFactory;
import traceability.Traces;

public class TraceabilityUtils {
    public static Map<String, String> BETTER_DESCRIPTION = new WeakHashMap<String, String>();

    public static String getUsername() {
        try {
            Class<?> c = null;
            Object o = null;
            Method method = null;
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                c = Class.forName("com.sun.security.auth.module.NTSystem");
                o = Class.forName("com.sun.security.auth.module.NTSystem").newInstance();
                method = c.getDeclaredMethod("getName", new Class[0]);
            }
            if (System.getProperty("os.name").toLowerCase().contains("linux")) {
                c = Class.forName("com.sun.security.auth.module.UnixSystem");
                o = Class.forName("com.sun.security.auth.module.UnixSystem").newInstance();
                method = c.getDeclaredMethod("getUsername", new Class[0]);
            }
            if (System.getProperty("os.name").toLowerCase().contains("solaris")) {
                c = Class.forName("com.sun.security.auth.module.SolarisSystem");
                o = Class.forName("com.sun.security.auth.module.SolarisSystem").newInstance();
                method = c.getDeclaredMethod("getUsername", new Class[0]);
            }
            if (c != null) {
                return (String)method.invoke(o, new Object[0]);
            }
        }
        catch (Exception exception) {}
        return System.getProperty("user.name");
    }

    public static String getProjectName(Resource resource) {
        if (resource != null && resource.getURI().isPlatformResource()) {
            String result = resource.getURI().segment(1);
            if (BETTER_DESCRIPTION.containsKey(result)) {
                result = BETTER_DESCRIPTION.get(result);
            }
            return result;
        }
        return null;
    }

    public static String getProjectName(EObject eObject) {
        return TraceabilityUtils.getProjectName(eObject.eResource());
    }

    public static <T> boolean addTrace(Traces currentCategory, T result) {
        if (result instanceof Trace || result instanceof LogEntry) {
            currentCategory.getTraces().add((Object)((EObject)result));
            return true;
        }
        return false;
    }

    public static Traces createTraceModel(URI uri, String originalSourceURL, ResourceSet resourceSet, boolean loadIfExists, String fullName) {
        Resource traces = null;
        try {
            traces = resourceSet.getResource(uri, false);
        }
        catch (Exception exception) {}
        if (traces == null && loadIfExists) {
            try {
                traces = resourceSet.getResource(uri, true);
            }
            catch (Exception exception) {}
        }
        if (traces == null) {
            traces = resourceSet.createResource(uri);
        }
        int index = -1;
        for (EObject eObject : new ArrayList(traces.getContents())) {
            if (eObject instanceof Traces) {
                Traces tracesRoot = (Traces)eObject;
                if (fullName.equals(tracesRoot.getFullName())) {
                    index = traces.getContents().indexOf((Object)eObject);
                    traces.getContents().remove((Object)eObject);
                    continue;
                }
                if (tracesRoot.getFullName() != null) continue;
                traces.getContents().remove((Object)eObject);
                continue;
            }
            traces.getContents().remove((Object)eObject);
        }
        if (index == -1) {
            index = traces.getContents().size();
        }
        Traces tracesRoot = TraceabilityFactory.eINSTANCE.createTraces();
        tracesRoot.setOriginalSourceURL(originalSourceURL);
        tracesRoot.setDate(new Date());
        tracesRoot.setUsername(TraceabilityUtils.getUsername());
        tracesRoot.setFullName(fullName);
        try {
            tracesRoot.setLocation(Inet4Address.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        traces.getContents().add(index, (Object)tracesRoot);
        return tracesRoot;
    }
}

