/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.tests;

import org.eclipse.mdht.uml.cda.AssignedEntity;
import org.eclipse.mdht.uml.cda.Authenticator;
import org.eclipse.mdht.uml.cda.Author;
import org.eclipse.mdht.uml.cda.AuthoringDevice;
import org.eclipse.mdht.uml.cda.CDAFactory;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.hl7.vocab.ActMood;
import org.eclipse.mdht.uml.hl7.vocab.ContextControl;
import org.eclipse.mdht.uml.hl7.vocab.EntityDeterminer;
import org.eclipse.mdht.uml.hl7.vocab.ParticipationType;
import org.eclipse.mdht.uml.hl7.vocab.RoleClassAssignedEntity;

public class InfrastructureRootTest {
    public static boolean testIsDefined() {
        boolean bItWorked = true;
        AssignedEntity oAssignedEntity = CDAFactory.eINSTANCE.createAssignedEntity();
        if (oAssignedEntity.isDefined("classCode")) {
            bItWorked = false;
        }
        oAssignedEntity.setClassCode(RoleClassAssignedEntity.ASSIGNED);
        if (!oAssignedEntity.isDefined("classCode")) {
            bItWorked = false;
        }
        return bItWorked;
    }

    public static boolean testIsClassCodeDefined() {
        boolean bItWorked = true;
        AssignedEntity oAssignedEntity = CDAFactory.eINSTANCE.createAssignedEntity();
        if (oAssignedEntity.isClassCodeDefined()) {
            bItWorked = false;
        }
        oAssignedEntity.setClassCode(RoleClassAssignedEntity.ASSIGNED);
        if (!oAssignedEntity.isClassCodeDefined()) {
            bItWorked = false;
        }
        return bItWorked;
    }

    public static boolean testIsTypeCodeDefined() {
        boolean bItWorked = true;
        Authenticator oAuthenticator = CDAFactory.eINSTANCE.createAuthenticator();
        if (oAuthenticator.isTypeCodeDefined()) {
            bItWorked = false;
        }
        oAuthenticator.setTypeCode(ParticipationType.ADM);
        if (!oAuthenticator.isTypeCodeDefined()) {
            bItWorked = false;
        }
        return bItWorked;
    }

    public static boolean testIsContextControlCodeDefined() {
        boolean bItWorked = true;
        Author oAuthor = CDAFactory.eINSTANCE.createAuthor();
        if (oAuthor.isContextControlCodeDefined()) {
            bItWorked = false;
        }
        oAuthor.setContextControlCode(ContextControl.AN);
        if (!oAuthor.isContextControlCodeDefined()) {
            bItWorked = false;
        }
        return bItWorked;
    }

    public static boolean testIsDeterminerCodeDefined() {
        boolean bItWorked = true;
        AuthoringDevice oAuthoringDevice = CDAFactory.eINSTANCE.createAuthoringDevice();
        if (oAuthoringDevice.isDeterminerCodeDefined()) {
            bItWorked = false;
        }
        oAuthoringDevice.setDeterminerCode(EntityDeterminer.INSTANCE);
        if (!oAuthoringDevice.isDeterminerCodeDefined()) {
            bItWorked = false;
        }
        return bItWorked;
    }

    public static boolean testIsMoodCodeDefined() {
        boolean bItWorked = true;
        ClinicalDocument oClinicalDocument = CDAFactory.eINSTANCE.createClinicalDocument();
        if (oClinicalDocument.isMoodCodeDefined()) {
            bItWorked = false;
        }
        oClinicalDocument.setMoodCode(ActMood.APT);
        if (!oClinicalDocument.isMoodCodeDefined()) {
            bItWorked = false;
        }
        return bItWorked;
    }

    public static void main(String[] args) throws Exception {
        boolean bFailure = false;
        if (!InfrastructureRootTest.testIsDefined()) {
            bFailure = true;
            System.out.println("testIsDefined failed!");
        }
        if (!InfrastructureRootTest.testIsClassCodeDefined()) {
            bFailure = true;
            System.out.println("testIsClassCodeDefined failed!");
        }
        if (!InfrastructureRootTest.testIsTypeCodeDefined()) {
            bFailure = true;
            System.out.println("testIsTypeCodeDefined failed!");
        }
        if (!InfrastructureRootTest.testIsContextControlCodeDefined()) {
            bFailure = true;
            System.out.println("testIsTypeCodeDefined failed!");
        }
        if (!InfrastructureRootTest.testIsDeterminerCodeDefined()) {
            bFailure = true;
            System.out.println("testIsDeterminerCodeDefined failed!");
        }
        if (!InfrastructureRootTest.testIsMoodCodeDefined()) {
            bFailure = true;
            System.out.println("testIsMoodCodeDefined failed!");
        }
        if (bFailure) {
            System.out.println("One or more tests Failed!!!");
        } else {
            System.out.println("All tests completed successfully...");
        }
    }
}

