/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.api.dotnet.action;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.mdht.api.GenerateAPIForProgrammingLanguageAction;
import org.eclipse.mdht.api.dotnet.CDAOCL2CSharpHandler;
import org.eclipse.mdht.transformation.ocl.OCLTransformation;
import org.eclipse.mdht.transformation.ocl2csharp.OCL2CSharpTransformationForUML;
import org.eclipse.mdht.uml.cda.core.util.CDACommonUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class GenerateDotNetAction
extends GenerateAPIForProgrammingLanguageAction {
    protected String getTargetLanguage() {
        return "C#";
    }

    protected File genfolder(File modelFolder) {
        String folder = System.getProperty("DOTNET_TARGET_FOLDER");
        if (folder != null) {
            return new File(folder);
        }
        return new File(modelFolder.getParentFile(), "src-dotnet");
    }

    protected String getRootFileExtension() {
        return ".cs";
    }

    protected String getPlugin() {
        return "org.eclipse.mdht.api.dotnet";
    }

    protected void writeEntity(String content, String fileName) throws IOException {
        content = content.replace("NullFlavor.", "Nehta.HL7.CDA.NullFlavor.");
        this.creator.writeFile(content, new File(this.genfolder, String.valueOf(fileName) + this.getRootFileExtension()));
    }

    protected OCLTransformation<Package, Classifier, ?, Property, ?, ?, ?, ?, ?, ?, ?, ?> createTrafo(ResourceSet resourceSet) {
        return new OCL2CSharpTransformationForUML(resourceSet, new CDAOCL2CSharpHandler());
    }

    protected String printIsOptionalPresent(String var) {
        return String.valueOf(var) + ".Count != 0";
    }

    protected String printRetrieveOptional(String var) {
        return String.valueOf(var) + ".Last()";
    }

    protected String printOptional(String facade) {
        return "List<" + facade + ">";
    }

    protected String printLastOrDefault() {
        return "";
    }

    protected String printStreamClass() {
        return "List";
    }

    protected String setOrAdd(Property baseProperty, String value, String self) {
        return String.valueOf(self) + "." + this.trafo.getQualifiedName((Object)baseProperty) + " = SetOrAdd(" + self + "." + this.trafo.getQualifiedName((Object)baseProperty) + ", " + value + ");\n";
    }

    protected void closeNamespace(StringBuilder code) {
        code.append("}\n");
    }

    protected String printAddValidationError(String analysis) {
        return "vb.AddValidationMessage(vb.PathName, null, \"" + StringEscapeUtils.escapeJava((String)analysis) + "\");";
    }

    protected String printConstructor(Type clazz) {
        return "new " + this.getProgrammingType(clazz) + "()";
    }

    protected String printConstructor(Property property) {
        String type = this.getProgrammingType(property);
        if ("string".equals(type)) {
            return "String.Empty";
        }
        return "new " + ("QTY".equals(type) ? "PQ" : ("ANY".equals(type) ? "TEL" : type)) + (type.contains("[]") ? "{}" : "()");
    }

    protected void addStandardImports(StringBuilder code, String qualifiedClassName, String extendsClass) {
        code.append("using System;\n");
        code.append("using System.Collections.Generic;\n");
        code.append("using System.Linq;\n");
        code.append("using System.Text;\n");
        code.append("using Nehta.HL7.CDA;\n");
        code.append("using Nehta.VendorLibrary.Common;\n");
        code.append("\n");
        int index = qualifiedClassName.lastIndexOf(".");
        if (index != -1) {
            code.append("namespace " + qualifiedClassName.substring(0, index).toLowerCase() + "\n");
        }
        code.append("{\n");
        code.append("    public class " + qualifiedClassName.substring(index + 1) + (extendsClass != null ? " : " + extendsClass : "") + "\n");
        code.append("    {\n");
        code.append("\n");
    }

    protected String getMultivaluedGetter(Property property) {
        String result = super.getMultivaluedGetter(property);
        if ("operator".equals(result) || "event".equals(result)) {
            result = "@" + result;
        }
        return result;
    }

    protected String getFeaturePointer(Property baseProperty) {
        return "\"" + this.withoutAt(this.trafo.getQualifiedName((Object)baseProperty)) + "\"";
    }

    protected void defineProperty(StringBuilder pattern, Property property, String type, String returnBody, String setOrAdd) {
        if ("mixed".equals(property.getName())) {
            returnBody = "self." + this.trafo.getQualifiedName((Object)property) + " == null ? String.Empty : string.Join(String.Empty, self." + this.trafo.getQualifiedName((Object)property) + ")";
            setOrAdd = "self." + this.trafo.getQualifiedName((Object)property) + " = new string[] { value };\n";
        }
        if (this.hasPropertiesSupport()) {
            pattern.append("\t\tpublic " + type + " " + this.facadeProperty(property) + "\n");
            pattern.append("\t\t{\n");
            if (returnBody != null) {
                pattern.append("\t\t\tget\n");
                pattern.append("\t\t\t{\n");
                pattern.append("\t\t\t\treturn " + returnBody + ";\n");
                pattern.append("\t\t\t}\n");
            }
            if (setOrAdd != null) {
                pattern.append("\t\t\tset\n");
                pattern.append("\t\t\t{\n");
                pattern.append("\t\t\t\t" + setOrAdd);
                pattern.append("\t\t\t}\n");
            }
            pattern.append("\t\t}\n\n");
            return;
        }
        if (returnBody != null) {
            pattern.append("\t\tpublic " + type + " " + this.facadeProperty(property) + "()");
            pattern.append("\t\t{\n");
            pattern.append("\t\t\treturn " + returnBody + ";\n");
            pattern.append("\t\t}\n\n");
        }
        if (setOrAdd != null) {
            pattern.append("\t\tpublic void " + this.facadeProperty(property) + "(" + type + " value)");
            pattern.append("\t\t{\n");
            pattern.append("\t\t\t" + setOrAdd);
            pattern.append("\t\t}\n\n");
        }
    }

    protected boolean hasPropertiesSupport() {
        return false;
    }

    private String withoutAt(String name) {
        if (name.startsWith("@")) {
            return name.substring(1);
        }
        return name;
    }

    protected String getProgrammingType(Type t) {
        if (t instanceof Class) {
            t = CDACommonUtils.getCDAType((Classifier)((Class)t));
        }
        String type = t != null ? this.trafo.getName((Object)t) : "Object";
        type = this.adjustProgrammingType(type);
        return type;
    }

    protected String adjustProgrammingType(String type) {
        type = type.replaceAll("^EBooleanObject", "bool");
        type = type.replaceAll("^EBigInteger", "string");
        type = type.replaceAll("^csType", "string");
        type = type.replaceAll("^stType", "string");
        type = type.replaceAll("^tsType", "string");
        type = type.replaceAll("^ActMoodPredicate", "ActMood");
        type = type.replaceAll("^x_ActMoodDefEvn", "ActMood");
        type = type.replaceAll("^uid", "string");
        type = type.replaceAll("^TypeId", "typeId");
        type = type.replaceAll("^POCD_MT000040SDTCPatient", "POCD_MT000040Patient");
        type = type.replaceAll("^POCD_MT000040ClinicalStatement", "POCD_MT000040Act");
        type = type.replaceAll("^POCD_MT000040RegionOfInterestValue", "POCD_MT000040RegionOfInterestvalue");
        type = type.replaceAll("^POCD_MT000040InfrastructureRootTypeId", "POCD_MT000040InfrastructureRoottypeId");
        type = type.replaceAll("^POCD_MT000040StrucDocText", "StrucDocText");
        type = type.replaceAll("^String", "string");
        type = type.replaceAll("^Real", "double");
        type = type.replaceAll("^EByteArray", "byte[]");
        type = type.replaceAll("^EBigDecimal", "string");
        type = type.replaceAll("^EIVL_event", "EIVLevent");
        type = type.replaceAll("^EFeatureMapEntry", "string");
        return type;
    }

    protected String getProgrammingType(Property property) {
        String type = this.getProgrammingType(property.getType());
        if ("ADXP".equals(type) && CDACommonUtils.getCDAProperty((Property)property) != null) {
            type = "adxp" + CDACommonUtils.getCDAProperty((Property)property).getName();
        }
        if ("ENXP".equals(type) && CDACommonUtils.getCDAProperty((Property)property) != null) {
            type = "en" + CDACommonUtils.getCDAProperty((Property)property).getName();
        }
        if ("double".equals(type) && "probability".equals(property.getName()) && "UVP_PQ".equals(property.getClass_().getName())) {
            type = "float";
        }
        if ("ED".equals(type) && "thumbnail".equals(property.getName())) {
            type = "thumbnail";
        }
        return type;
    }
}

