/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.handlers;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mdht.cda.xml.ui.internal.Logger;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.handlers.HandlerUtil;
import org.openhealthtools.mdht.uml.cda.consol.ConsolPackage;
import org.openhealthtools.mdht.uml.cda.consol.GeneralHeaderConstraints;
import org.osgi.framework.Bundle;

public class OpenUsingStyleSheet
extends AbstractHandler {
    private static void open(IWebBrowser browser, IFile sourceFile) throws Exception {
        ConsolPackage.eINSTANCE.getContinuityOfCareDocument();
        URI cdaURI = URI.createFileURI((String)sourceFile.getLocation().toOSString());
        ClinicalDocument clinicalDocument = CDAUtil.load((URI)cdaURI);
        String xslEntry = null;
        String xslFolder = null;
        if (clinicalDocument instanceof GeneralHeaderConstraints) {
            xslEntry = "resources/xsl/vha/cda.xsl";
            xslFolder = "resources/xsl/vha";
        } else {
            xslEntry = "resources/xsl/CDA.xsl";
            xslFolder = "resources/xsl";
        }
        Bundle bundle = Platform.getBundle((String)"org.eclipse.mdht.cda.xml.ui");
        URL fileURL = bundle.getEntry(xslEntry);
        File tempFile = File.createTempFile(sourceFile.getName(), ".html");
        Path temporaryDirectory = Paths.get(tempFile.getParent(), new String[0]);
        java.net.URI csspath = URIUtil.toURI((URL)FileLocator.toFileURL((URL)bundle.getEntry(xslFolder)));
        DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(csspath), "*.css");
        for (Path entry : stream) {
            Files.copy(entry, temporaryDirectory.resolve(entry.getFileName()), StandardCopyOption.REPLACE_EXISTING);
        }
        OpenUsingStyleSheet.applyXSL(sourceFile, tempFile, fileURL);
        browser.openURL(tempFile.toURI().toURL());
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection iss = (IStructuredSelection)selection;
                for (Object o : iss) {
                    if (!(o instanceof IFile)) continue;
                    IFile sourceFile = (IFile)o;
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser("org.eclipse.mdht.cda.xml.ui");
                    OpenUsingStyleSheet.open(browser, sourceFile);
                }
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return null;
    }

    private static void applyXSL(IFile cdaFileName, File temporaryFile, URL styleSheetURL) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        Templates template = factory.newTemplates(new StreamSource(styleSheetURL.openConnection().getInputStream()));
        Transformer xformer = template.newTransformer();
        StreamSource source = new StreamSource(cdaFileName.getContents());
        StreamResult result = new StreamResult(new FileOutputStream(temporaryFile));
        xformer.transform(source, result);
    }
}

