/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.handlers;

import com.google.common.base.Stopwatch;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mdht.cda.xml.ui.handlers.DeidentifyCDAHandler;

public class PackageCDAHandler
extends DeidentifyCDAHandler {
    public static void zipFolder(IFolder folder, IFile zipFile) throws IOException, CoreException {
        PackageCDAHandler.zipFolder(folder, new FileOutputStream(zipFile.getLocation().toOSString()));
    }

    public static void zipFolder(IFolder folder, OutputStream outputStream) throws IOException, CoreException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            PackageCDAHandler.processFolder(folder, zipOutputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void processFolder(IFolder folder, ZipOutputStream zipOutputStream) throws IOException, CoreException {
        folder.refreshLocal(2, null);
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                ZipEntry zipEntry = new ZipEntry(file.getName());
                zipOutputStream.putNextEntry(zipEntry);
                IOUtils.copy((InputStream)file.getContents(), (OutputStream)zipOutputStream);
                zipOutputStream.closeEntry();
            }
            ++n2;
        }
    }

    @Override
    protected void processFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IFileStore fs1;
        int filectr = 1;
        long currentProcessingTime = 1L;
        long totalBytes = 0L;
        long totalBytes2 = 0L;
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        this.setFolderPrefix(String.valueOf(folder.getName()) + "Deidentified" + DATE_FORMAT3.format(new Date()));
        this.documents.clear();
        IFile documentlist = folder.getFile("documents.txt");
        if (!documentlist.exists()) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(documentlist.getContents()));
        ArrayList<String> files = new ArrayList<String>();
        try {
            String fileName;
            while ((fileName = reader.readLine()) != null) {
                files.add(fileName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (monitor.isCanceled()) {
                monitor.done();
                break;
            }
            if (resource instanceof IFile && files.contains(resource.getName())) {
                IFile file = (IFile)resource;
                EFS.getStore((URI)file.getLocationURI());
                if ("XML".equalsIgnoreCase(file.getFileExtension())) {
                    this.documents.add(file);
                    fs1 = EFS.getStore((URI)file.getLocationURI());
                    totalBytes += fs1.fetchInfo().getLength();
                }
            }
            ++n2;
        }
        totalBytes2 = totalBytes;
        monitor.setTaskName("DeIdentify Folder (" + format2Places.format((double)totalBytes2 / 1000000.0) + " MB) ");
        Comparator<IFile> c = new Comparator<IFile>(){

            @Override
            public int compare(IFile file1, IFile file2) {
                try {
                    IFileStore fs1 = EFS.getStore((URI)file1.getLocationURI());
                    IFileStore fs2 = EFS.getStore((URI)file2.getLocationURI());
                    if (fs1.fetchInfo().getLength() < fs2.fetchInfo().getLength()) {
                        return 1;
                    }
                    return -1;
                }
                catch (CoreException coreException) {
                    return 0;
                }
            }
        };
        Collections.sort(this.documents, c);
        currentProcessingTime = 0L;
        long estimatedTimeLeft = 0L;
        for (IFile document : this.documents) {
            if (!files.contains(document.getName())) continue;
            monitor.worked(1);
            if (estimatedTimeLeft != 0L) {
                if (estimatedTimeLeft > 60L) {
                    monitor.setTaskName("DeIdentify Folder (" + format2Places.format((double)totalBytes2 / 1000000.0) + " MB), Estimated Time to finish : " + (int)estimatedTimeLeft / 60 + " Minutes ");
                } else {
                    monitor.setTaskName("DeIdentify Folder (" + format2Places.format((double)totalBytes2 / 1000000.0) + " MB), Estimated Time to finish : " + (int)estimatedTimeLeft + " Seconds ");
                }
            }
            fs1 = EFS.getStore((URI)document.getLocationURI());
            long fileSize = fs1.fetchInfo().getLength();
            monitor.subTask("Processing " + StringUtils.center((String)StringUtils.abbreviate((String)document.getName(), (int)16), (int)16) + "(" + format2Places.format((double)fs1.fetchInfo().getLength() / 1000000.0) + " MB)" + " File # " + StringUtils.center((String)String.valueOf(filectr++), (int)10) + " LAST " + StringUtils.center((String)String.valueOf((double)currentProcessingTime / 1000.0), (int)6) + " Seconds");
            try {
                stopwatch.reset();
                stopwatch.start();
                this.deidentifyCDA(document);
                stopwatch.stop();
                currentProcessingTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                long ratePerSecond = fileSize / stopwatch.elapsed(TimeUnit.MILLISECONDS);
                estimatedTimeLeft = (totalBytes -= fileSize) / ratePerSecond / 1000L;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (monitor.isCanceled()) break;
        }
        try {
            PackageCDAHandler.zipFolder(folder.getFolder(this.getFolderPrefix()), folder.getFile(String.valueOf(this.getFolderPrefix()) + ".zip"));
            folder.getFolder(this.getFolderPrefix()).delete(true, null);
            folder.refreshLocal(2, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

