/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mdht.uml.transform.EcoreTransformUtil;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.util.UMLUtil;

public abstract class AbstractTransformer {
    protected TransformerOptions transformerOptions;

    public AbstractTransformer() {
        this(new TransformerOptions());
    }

    public AbstractTransformer(TransformerOptions options) {
        this.transformerOptions = options;
    }

    public abstract void transformModelElement(Element var1);

    public abstract void saveResources();

    protected Package initializeModelPackageFrom(Element element, String newModelPath, String suffix, String nsPrefix, String prefix) {
        Package sourcePkg = element.getNearestPackage();
        Package newModelPkg = null;
        URI newModelURI = null;
        if (newModelPath != null) {
            newModelURI = URI.createFileURI((String)newModelPath);
        }
        if (newModelURI == null) {
            newModelURI = sourcePkg.eResource().getURI();
            newModelURI = newModelURI.trimFileExtension();
            newModelURI = newModelURI.trimSegments(1).appendSegment(String.valueOf(newModelURI.lastSegment()) + "_" + suffix);
            newModelURI = newModelURI.appendFileExtension(sourcePkg.eResource().getURI().fileExtension());
        }
        Resource newModelResource = element.eResource().getResourceSet().createResource(newModelURI);
        newModelPkg = UMLFactory.eINSTANCE.createPackage();
        newModelResource.getContents().add((Object)newModelPkg);
        Stereotype ePackage = EcoreTransformUtil.getEcoreStereotype((EObject)sourcePkg, "EPackage");
        UMLUtil.safeApplyStereotype((Element)newModelPkg, (Stereotype)ePackage);
        newModelPkg.setValue(ePackage, "nsPrefix", (Object)nsPrefix);
        newModelPkg.setValue(ePackage, "prefix", (Object)prefix);
        newModelPkg.setName(sourcePkg.getName());
        newModelPkg.setValue(ePackage, "packageName", (Object)sourcePkg.getName());
        return newModelPkg;
    }
}

