/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform.ecore;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.transform.AbstractTransform;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.PluginPropertiesUtil;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.ecore.AnnotationsUtil;
import org.eclipse.mdht.uml.transform.ecore.IEcoreProfileReflection;
import org.eclipse.mdht.uml.transform.internal.Logger;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class TransformAbstract
extends AbstractTransform {
    public static final String LF = System.getProperty("line.separator");
    public static final String VALIDATION_ERROR = "constraints.validation.error";
    public static final String VALIDATION_WARNING = "constraints.validation.warning";
    public static final String VALIDATION_INFO = "constraints.validation.info";
    private static final String VALIDATION_QUERY = "constraints.validation.query";
    public static final String PARENT_CLASS_NULLFLAVOR_CHECK_STRING_PREPEND = " ( self.isNullFlavorUndefined() implies (";
    public static final String PARENT_CLASS_NULLFLAVOR_CHECK_STRING_APPEND = " ))";
    private final IEcoreProfileReflection ecoreProfile;

    public TransformAbstract(TransformerOptions options, IBaseModelReflection baseModelReflection) {
        super(options, baseModelReflection);
        this.ecoreProfile = baseModelReflection.getAdapter(IEcoreProfileReflection.class);
        if (this.ecoreProfile == null) {
            throw new IllegalArgumentException("baseModelReflection does not provide IEcoreProfileReflection adapter required for UML-to-Ecore transformation");
        }
    }

    protected final IEcoreProfileReflection getEcoreProfile() {
        return this.ecoreProfile;
    }

    public boolean hasValidationSupport(Element element) {
        return this.getEcoreProfile().getAppliedValidationStereotype(element) != null;
    }

    public void addValidationSupport(Property property, IEcoreProfileReflection.ValidationStereotypeKind kind, String constraintName) {
        IEcoreProfileReflection.ValidationSeverityKind severity = this.getEcoreProfile().getValidationSeverity((Element)property, kind);
        String message = this.getEcoreProfile().getValidationMessage((Element)property, kind);
        Class constrainedClass = property.getClass_();
        if (severity != null) {
            switch (severity) {
                case INFO: {
                    this.addValidationInfo(constrainedClass, constraintName, message);
                    break;
                }
                case WARNING: {
                    this.addValidationWarning(constrainedClass, constraintName, message);
                    break;
                }
                default: {
                    this.addValidationError(constrainedClass, constraintName, message);
                    break;
                }
            }
        } else {
            this.addValidationError(constrainedClass, constraintName, message);
        }
    }

    public void addValidationError(Class constrainedClass, String constraintName, String message) {
        AnnotationsUtil annotationsUtil = this.getEcoreProfile().annotate((Element)constrainedClass);
        annotationsUtil.addAnnotation(VALIDATION_ERROR, constraintName);
        annotationsUtil.saveAnnotations();
        this.addValidationMessage(constrainedClass, constraintName, message);
    }

    public void addValidationWarning(Class constrainedClass, String constraintName, String message) {
        AnnotationsUtil annotationsUtil = this.getEcoreProfile().annotate((Element)constrainedClass);
        annotationsUtil.addAnnotation(VALIDATION_WARNING, constraintName);
        annotationsUtil.saveAnnotations();
        this.addValidationMessage(constrainedClass, constraintName, message);
    }

    public void addValidationInfo(Class constrainedClass, String constraintName, String message) {
        AnnotationsUtil annotationsUtil = this.getEcoreProfile().annotate((Element)constrainedClass);
        annotationsUtil.addAnnotation(VALIDATION_INFO, constraintName);
        annotationsUtil.saveAnnotations();
        this.addValidationMessage(constrainedClass, constraintName, message);
    }

    public void addValidationMessage(Class constrainedClass, String constraintName, String message) {
        PluginPropertiesUtil properties;
        if (message == null) {
            message = String.valueOf(constraintName) + " error message";
        }
        if ((properties = this.transformerOptions.getPluginPropertiesUtil()) != null) {
            properties.addProperty(this.generatePropertyMessageKey(constrainedClass, constraintName), message);
        }
    }

    protected String generatePropertyMessageKey(Class constrainedClass, String constraintName) {
        String propertyMessageKey = String.valueOf(constrainedClass.getQualifiedName()) + constraintName;
        if (constrainedClass.getNearestPackage() != null) {
            propertyMessageKey = propertyMessageKey.replaceFirst(String.valueOf(constrainedClass.getNearestPackage().getName()) + "::", "");
        }
        return propertyMessageKey.replace("::", "");
    }

    protected void addOCLConstraint(Property property, IEcoreProfileReflection.ValidationStereotypeKind stereotype, StringBuffer body) {
        this.addOCLConstraint(property, stereotype, body, null);
    }

    protected Constraint addOCLConstraint(Property property, IEcoreProfileReflection.ValidationStereotypeKind stereotype, StringBuffer body, String constraintName) {
        if (constraintName == null) {
            constraintName = this.createConstraintName((NamedElement)property);
        }
        if (property.getClass_().getOwnedRule(constraintName) != null) {
            String message = "Constraint name already defined: '" + constraintName + "' in " + property.getClass_().getQualifiedName();
            Logger.log(2, message);
            this.addValidationSupport(property, stereotype, constraintName);
            return null;
        }
        Property baseProperty = this.getBaseProperty(property);
        String selfName = "self." + baseProperty.getName();
        String nullFlavorBody = body.toString();
        boolean hasNullFlavor = false;
        if (baseProperty.getType() instanceof Class) {
            hasNullFlavor = this.isSubTypeOfANY((Classifier)((Class)baseProperty.getType()));
        }
        if (this.enableVariation_UseOriginalLowerbound()) {
            if (hasNullFlavor && property.getLower() == 0) {
                nullFlavorBody = baseProperty.upperBound() == 1 ? "((not " + selfName + ".oclIsUndefined()) and " + selfName + ".isNullFlavorUndefined()) implies (" + body + ")" : "((not " + selfName + "->isEmpty()) and " + selfName + "->exists(element | element.isNullFlavorUndefined()))" + " implies (" + body + ")";
            } else if (property.getLower() == 0) {
                nullFlavorBody = baseProperty.upperBound() == 1 ? "(not " + selfName + ".oclIsUndefined()) implies (" + body + ")" : "(not " + selfName + "->isEmpty()) implies (" + body + ")";
            }
        } else if (hasNullFlavor && !this.getEcoreProfile().isMandatory((Element)property)) {
            nullFlavorBody = baseProperty.upperBound() == 1 ? "(" + selfName + ".oclIsUndefined() or " + selfName + ".isNullFlavorUndefined()) implies (" + body + ")" : "(" + selfName + "->isEmpty() or " + selfName + "->exists(element | element.isNullFlavorUndefined()))" + " implies (" + body + ")";
        }
        if (property.getUpper() == 0 && property.getLower() == 0) {
            nullFlavorBody = baseProperty.upperBound() == 1 ? String.valueOf(selfName) + ".oclIsUndefined()" : String.valueOf(selfName) + "->isEmpty()";
        }
        if (property.eContainer() instanceof Class && this.isSubTypeOfANY((Classifier)((Class)property.eContainer()))) {
            nullFlavorBody = PARENT_CLASS_NULLFLAVOR_CHECK_STRING_PREPEND + nullFlavorBody + PARENT_CLASS_NULLFLAVOR_CHECK_STRING_APPEND;
        }
        Constraint result = property.getClass_().createOwnedRule(constraintName, UMLPackage.eINSTANCE.getConstraint());
        result.getConstrainedElements().add((Object)property.getClass_());
        OpaqueExpression expression = (OpaqueExpression)result.createSpecification(null, null, UMLPackage.eINSTANCE.getOpaqueExpression());
        expression.getLanguages().add((Object)"OCL");
        expression.getBodies().add((Object)nullFlavorBody);
        this.addValidationSupport(property, stereotype, constraintName);
        result.getConstrainedElements().add((Object)property);
        return result;
    }

    protected String createInheritedConstraintName(Property property, IEcoreProfileReflection.ValidationStereotypeKind stereotype) {
        String constraintName = null;
        if (this.getEcoreProfile().getValidationSeverity((Element)property, stereotype) == IEcoreProfileReflection.ValidationSeverityKind.ERROR) {
            Property inheritedProperty = UMLUtil.getInheritedProperty((Property)property);
            if (this.getEcoreProfile().inheritsConstraintName(property, inheritedProperty, stereotype)) {
                constraintName = this.createInheritedConstraintName(inheritedProperty, stereotype);
            }
        }
        if (constraintName == null) {
            constraintName = this.createConstraintName((NamedElement)property);
        }
        return constraintName;
    }

    Class getInitialTemplateClass(Property property) {
        Class c = property.getClass_();
        for (Property p : property.getRedefinedProperties()) {
            if (this.isBaseModel((Element)property.getClass_(), (Element)p) || this.isDatatypesModelElement((Element)property.getClass_(), (Element)p)) continue;
            c = this.getInitialTemplateClass(p);
        }
        return c;
    }

    Property getInitialProperty(Property property) {
        Property pp = property;
        for (Property p : property.getRedefinedProperties()) {
            if (this.isBaseModel((Element)property.getClass_(), (Element)p) || this.isDatatypesModelElement((Element)property.getClass_(), (Element)p)) continue;
            pp = this.getInitialProperty(p);
        }
        return pp;
    }

    private String generatePrefix(NamedElement constrainedClass) {
        String prefix = constrainedClass.getQualifiedName().replace("::", "").replace(constrainedClass.getNearestPackage().getName(), "");
        return prefix;
    }

    private static String reverseCamelCase(String name) {
        if (!StringUtils.isEmpty((String)name)) {
            return StringUtils.capitalise((String)name);
        }
        return name;
    }

    protected String createConstraintName(NamedElement property, String suffix) {
        return String.valueOf(this.createConstraintName(property)) + suffix;
    }

    public Constraint getConstraintByName(Constraint constraint) {
        for (Classifier parent : ((Classifier)constraint.getOwner()).allParents()) {
            for (Constraint c : parent.getOwnedRules()) {
                String inheritedName = String.valueOf(this.generatePrefix((NamedElement)parent)) + constraint.getName();
                if (!constraint.getName().equalsIgnoreCase(c.getName()) && !inheritedName.equalsIgnoreCase(c.getName())) continue;
                return c;
            }
        }
        return constraint;
    }

    protected String createConstraintName(NamedElement namedElement) {
        String constraintName = "";
        Object baseNamedElement = null;
        baseNamedElement = namedElement instanceof Property ? this.getInitialProperty((Property)namedElement) : (namedElement instanceof Constraint ? this.getConstraintByName((Constraint)namedElement) : namedElement);
        if (baseNamedElement != null) {
            if (baseNamedElement.getOwner() instanceof NamedElement) {
                constraintName = this.generatePrefix((NamedElement)baseNamedElement.getOwner());
            }
            constraintName = baseNamedElement.getName().startsWith(constraintName) ? TransformAbstract.reverseCamelCase(baseNamedElement.getName()) : String.valueOf(constraintName) + TransformAbstract.reverseCamelCase(baseNamedElement.getName());
        }
        return constraintName;
    }

    protected String getConstraintDependency(AnnotationsUtil annotations, String constraintName) {
        return annotations.getAnnotation("constraints.validation.dependOn." + constraintName);
    }

    protected void setConstraintDependency(AnnotationsUtil annotations, String constraintName, String dependencyName) {
        annotations.setAnnotation("constraints.validation.dependOn." + constraintName, dependencyName);
    }

    protected void annotateQueryConstraint(Constraint constraint, Class context) {
        AnnotationsUtil annotationsUtil = this.getEcoreProfile().annotate((Element)context);
        annotationsUtil.addAnnotation(VALIDATION_QUERY, constraint.getName());
        annotationsUtil.saveAnnotations();
    }

    public static String normalizeConstraintName(String constraintName) {
        String[] parts;
        String result = "";
        String[] stringArray = parts = constraintName.split("_");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            result = String.valueOf(result) + part.substring(0, 1).toUpperCase() + part.substring(1);
            ++n2;
        }
        return result;
    }

    public boolean isSubTypeOfANY(Classifier clazz) {
        boolean retVal = false;
        if (clazz instanceof Class) {
            List parentNames = UMLUtil.getAllParentNames((Classifier)clazz);
            retVal = parentNames.contains("ANY");
        }
        return retVal;
    }

    public boolean enableVariation_UseOriginalType() {
        return false;
    }

    public boolean enableVariation_UseOriginalLowerbound() {
        return false;
    }
}

