/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.dita;

import org.apache.commons.lang.StringUtils;
import org.eclipse.mdht.uml.cda.dita.DitaTransformerOptions;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.util.UMLSwitch;

public abstract class TransformAbstract
extends UMLSwitch<Object> {
    public static final String LF = System.getProperty("line.separator");
    protected DitaTransformerOptions transformerOptions;

    public TransformAbstract(DitaTransformerOptions options) {
        this.transformerOptions = options;
    }

    protected void removeModelElement(Element element) {
        if (!this.isRemoved(element)) {
            this.transformerOptions.getDeletedElementList().add(element);
        }
    }

    protected boolean isRemoved(Element element) {
        return this.transformerOptions.getDeletedElementList().contains(element);
    }

    public static String normalizeCodeName(String name) {
        String[] parts = name.trim().replaceAll(" +", " ").split(" ");
        StringBuilder result = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            result.append(part.substring(0, 1).toUpperCase());
            result.append(part.substring(1));
            ++n2;
        }
        return UML2Util.getValidJavaIdentifier((String)result.toString());
    }

    public static String getPublicationName(NamedElement namedElement) {
        if (namedElement != null) {
            String businessName = NamedElementUtil.getBusinessName((NamedElement)namedElement);
            if (!StringUtils.isEmpty((String)businessName) && businessName.compareTo(namedElement.getName()) == 0) {
                return UMLUtil.splitName((NamedElement)namedElement);
            }
            return businessName;
        }
        return "";
    }
}

