/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.dita;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.dita.DitaTransformerOptions;
import org.eclipse.mdht.uml.cda.dita.TransformAbstract;
import org.eclipse.mdht.uml.cda.dita.internal.Logger;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Type;

public class TransformCDA
extends TransformAbstract {
    private final String FORMALCLASSNAME = "FORMALCLASSNAME";
    private final String CLASSNAME = "CLASSNAME";
    private final String NARRATIVECLASSNAME = "NARRATIVECLASSNAME";

    private String readDITATemplateAsString(String fileName) throws IOException {
        IPath templatePath = this.transformerOptions.getOutputPath().removeLastSegments(1).append(fileName);
        byte[] buffer = new byte[(int)new File(templatePath.toOSString()).length()];
        BufferedInputStream f = null;
        try {
            f = new BufferedInputStream(new FileInputStream(templatePath.toOSString()));
            f.read(buffer);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new String(buffer);
    }

    public TransformCDA(DitaTransformerOptions options) {
        super(options);
    }

    private String[] createTemplateParameters(Class umlClass) {
        String[] templateParameters = new String[6];
        templateParameters[0] = "NARRATIVECLASSNAME";
        templateParameters[2] = "FORMALCLASSNAME";
        templateParameters[4] = "CLASSNAME";
        templateParameters[1] = umlClass.getName();
        templateParameters[3] = TransformAbstract.getPublicationName((NamedElement)umlClass);
        templateParameters[5] = umlClass.getName();
        return templateParameters;
    }

    public Object caseClass(Class umlClass) {
        String fileName = String.valueOf(umlClass.getName()) + ".dita";
        Class cdaClass = CDAModelUtil.getCDAClass((Classifier)umlClass);
        if (cdaClass != null) {
            if (CDAModelUtil.isClinicalDocument((Type)cdaClass)) {
                this.generateClinicalDocument(umlClass);
                this.transformerOptions.getDocumentList().add(fileName);
            } else if (CDAModelUtil.isSection((Type)cdaClass)) {
                this.generateSection(umlClass);
                this.transformerOptions.getSectionList().add(fileName);
            } else if (CDAModelUtil.isClinicalStatement((Type)cdaClass)) {
                if (!(umlClass.getOwner() instanceof Class)) {
                    this.generateClinicalStatement(umlClass);
                    this.transformerOptions.getClinicalStatementList().add(fileName);
                }
            } else if (!(umlClass.getOwner() instanceof Class)) {
                this.transformerOptions.getClassList().add(fileName);
            }
        } else {
            this.transformerOptions.getClassList().add(fileName);
        }
        return umlClass;
    }

    private void generateClinicalDocument(Class umlClass) {
        this.generateDitaFromTemplate(umlClass, this.createTemplateParameters(umlClass), umlClass.getName(), "dita", "classes", "templates/document.xml");
    }

    private void generateClinicalStatement(Class umlClass) {
        this.generateDitaFromTemplate(umlClass, this.createTemplateParameters(umlClass), umlClass.getName(), "dita", "classes", "templates/class.xml");
    }

    private void generateSection(Class umlClass) {
        String coupledClassName = "";
        boolean couple = false;
        for (Generalization generalization : umlClass.getGeneralizations()) {
            for (Comment comment : generalization.getOwnedComments()) {
                coupledClassName = generalization.getGeneral().getName();
                if ("couple".equals(comment.getBody())) {
                    couple = true;
                }
                if (!"skip".equals(comment.getBody())) continue;
                return;
            }
        }
        String[] templateParameters = this.createTemplateParameters(umlClass);
        if (couple) {
            templateParameters[1] = coupledClassName;
        }
        if (couple) {
            this.generateDitaFromTemplate(umlClass, templateParameters, umlClass.getName(), "dita", "classes", "templates/coupledsection.xml");
        } else {
            this.generateDitaFromTemplate(umlClass, templateParameters, umlClass.getName(), "dita", "classes", "templates/section.xml");
        }
        this.generateDitaFromTemplate(umlClass, templateParameters, String.valueOf(umlClass.getName()) + "Sample", "dita", "classes", "templates/sectionsample.xml");
        this.generateDitaFromTemplate(umlClass, templateParameters, String.valueOf(umlClass.getName()) + "Table", "dita", "classes", "templates/sectiontable.xml");
        this.generateDitaFromTemplate(umlClass, templateParameters, umlClass.getName(), "ditamap", "content", "templates/sectioncontent.xml");
    }

    private void generateDitaFromTemplate(Class umlClass, String[] templateParameters, String fileName, String fileExtension, String outputlocation, String templateName) {
        IPath filePath = this.transformerOptions.getOutputPath().append(outputlocation).addTrailingSeparator().append(fileName).addFileExtension(fileExtension);
        File file = filePath.toFile();
        try (PrintWriter writer = null;){
            try {
                file.createNewFile();
                writer = new PrintWriter(file);
                try {
                    String template = this.readDITATemplateAsString(templateName);
                    int index = 0;
                    while (index < templateParameters.length) {
                        template = template.replaceAll(templateParameters[index], templateParameters[index + 1]);
                        index += 2;
                    }
                    writer.println(template);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                Logger.logException(e);
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e1) {
                Logger.logException(e1);
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }
}

