/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.hl7.datatypes.util.DatatypesUtil;

public class ValidationResult
implements CDAUtil.ValidationHandler {
    private static final String EMF_COMMON_DIAGNOSTIC_SOURCE = "org.eclipse.emf.common";
    private static final String EMF_RESOURCE_DIAGNOSTIC_SOURCE = "org.eclipse.emf.ecore.resource";
    private static final String SCHEMA_VALIDATION_DIAGNOSTIC_SOURCE = "javax.xml.validation.Validator";
    private List<Diagnostic> allDiagnostics = new ArrayList<Diagnostic>();
    private List<Diagnostic> errorDiagnostics = new ArrayList<Diagnostic>();
    private List<Diagnostic> warningDiagnostics = new ArrayList<Diagnostic>();
    private List<Diagnostic> infoDiagnostics = new ArrayList<Diagnostic>();
    private boolean captureValidationStatistics = false;
    DatatypesUtil.ValidationStatistics validationStatistics = null;

    public ValidationResult() {
    }

    public ValidationResult(boolean captureValidationStatistics) {
        this.captureValidationStatistics = captureValidationStatistics;
    }

    public List<Diagnostic> getAllDiagnostics() {
        return Collections.unmodifiableList(this.allDiagnostics);
    }

    public List<Diagnostic> getDiagnostics(CDAUtil.Filter<Diagnostic> filter) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (Diagnostic diagnostic : this.getAllDiagnostics()) {
            if (!filter.accept(diagnostic)) continue;
            diagnostics.add(diagnostic);
        }
        return Collections.unmodifiableList(diagnostics);
    }

    public List<Diagnostic> getEMFValidationDiagnostics() {
        return this.getDiagnostics(new CDAUtil.Filter<Diagnostic>(){

            @Override
            public boolean accept(Diagnostic item) {
                return !ValidationResult.SCHEMA_VALIDATION_DIAGNOSTIC_SOURCE.equals(item.getSource()) && !ValidationResult.EMF_COMMON_DIAGNOSTIC_SOURCE.equals(item.getSource()) && !ValidationResult.EMF_RESOURCE_DIAGNOSTIC_SOURCE.equals(item.getSource());
            }
        });
    }

    public List<Diagnostic> getEMFResourceDiagnostics() {
        return this.getDiagnostics(new CDAUtil.Filter<Diagnostic>(){

            @Override
            public boolean accept(Diagnostic item) {
                return ValidationResult.EMF_COMMON_DIAGNOSTIC_SOURCE.equals(item.getSource()) || ValidationResult.EMF_RESOURCE_DIAGNOSTIC_SOURCE.equals(item.getSource());
            }
        });
    }

    public List<Diagnostic> getErrorDiagnostics() {
        return Collections.unmodifiableList(this.errorDiagnostics);
    }

    public List<Diagnostic> getInfoDiagnostics() {
        return Collections.unmodifiableList(this.infoDiagnostics);
    }

    public List<Diagnostic> getSchemaValidationDiagnostics() {
        return this.getDiagnostics(new CDAUtil.Filter<Diagnostic>(){

            @Override
            public boolean accept(Diagnostic item) {
                return ValidationResult.SCHEMA_VALIDATION_DIAGNOSTIC_SOURCE.equals(item.getSource());
            }
        });
    }

    public List<Diagnostic> getWarningDiagnostics() {
        return Collections.unmodifiableList(this.warningDiagnostics);
    }

    @Override
    public void handleError(Diagnostic diagnostic) {
        this.allDiagnostics.add(diagnostic);
        this.errorDiagnostics.add(diagnostic);
    }

    @Override
    public void handleInfo(Diagnostic diagnostic) {
        this.allDiagnostics.add(diagnostic);
        this.infoDiagnostics.add(diagnostic);
    }

    @Override
    public void handleWarning(Diagnostic diagnostic) {
        this.allDiagnostics.add(diagnostic);
        this.warningDiagnostics.add(diagnostic);
    }

    public boolean hasErrors() {
        return !this.errorDiagnostics.isEmpty();
    }

    @Override
    public DatatypesUtil.ValidationStatistics getValidationStatistics() {
        return this.validationStatistics;
    }

    @Override
    public void setValidationStatistics(DatatypesUtil.ValidationStatistics validationStatistics) {
        this.validationStatistics = validationStatistics;
    }

    @Override
    public boolean isCaptureValidationStatistics() {
        return this.captureValidationStatistics;
    }
}

