/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.revision.cache;

import org.eclipse.emf.cdo.common.revision.cache.CDORevisionCache;
import org.eclipse.emf.cdo.internal.common.revision.cache.lru.LRURevisionCache;
import org.eclipse.emf.cdo.internal.common.revision.cache.mem.MEMRevisionCache;
import org.eclipse.emf.cdo.internal.common.revision.cache.two.TwoLevelRevisionCache;

public final class CDORevisionCacheUtil {
    public static final int DEFAULT_CAPACITY_CURRENT = 1000;
    public static final int DEFAULT_CAPACITY_REVISED = 1000;

    private CDORevisionCacheUtil() {
    }

    public static CDORevisionCache createLRUCache(int capacityCurrent, int capacityRevised) {
        LRURevisionCache cache = new LRURevisionCache();
        cache.setCapacityCurrent(capacityCurrent);
        cache.setCapacityRevised(capacityRevised);
        return cache;
    }

    public static CDORevisionCache createMEMCache() {
        return new MEMRevisionCache();
    }

    public static CDORevisionCache createTwoLevelCache(CDORevisionCache level1, CDORevisionCache level2) {
        TwoLevelRevisionCache cache = new TwoLevelRevisionCache();
        cache.setLevel1(level1);
        cache.setLevel2(level2);
        return cache;
    }

    public static CDORevisionCache createDefaultCache(int capacityCurrent, int capacityRevised) {
        return CDORevisionCacheUtil.createTwoLevelCache(CDORevisionCacheUtil.createLRUCache(capacityCurrent, capacityRevised), CDORevisionCacheUtil.createMEMCache());
    }

    public static CDORevisionCache createDefaultCache() {
        return CDORevisionCacheUtil.createDefaultCache(1000, 1000);
    }
}

