/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.resource.CDOPathFeature;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.server.LongIDStore;
import org.eclipse.emf.cdo.internal.server.MEMStoreAccessor;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.net4j.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MEMStore
extends LongIDStore {
    public static final String TYPE = "mem";
    private Map<CDOID, List<CDORevision>> revisions = new HashMap<CDOID, List<CDORevision>>();

    public MEMStore() {
        super(TYPE);
    }

    public synchronized CDORevision getRevision(CDOID id) {
        List<CDORevision> list = this.revisions.get(id);
        if (list != null) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public synchronized CDORevision getRevisionByVersion(CDOID id, int version) {
        List<CDORevision> list = this.revisions.get(id);
        if (list != null) {
            return this.getRevisionByVersion(list, version);
        }
        return null;
    }

    public synchronized void addRevision(CDORevision revision) {
        CDORevision rev;
        CDOID id = revision.getID();
        List<CDORevision> list = this.revisions.get(id);
        if (list == null) {
            list = new ArrayList<CDORevision>();
            this.revisions.put(id, list);
        }
        if ((rev = this.getRevisionByVersion(list, revision.getVersion())) != null) {
            throw new IllegalStateException("Concurrent modification of revision " + rev);
        }
        list.add(revision);
    }

    public synchronized boolean removeRevision(CDORevision revision) {
        CDOID id = revision.getID();
        List<CDORevision> list = this.revisions.get(id);
        if (list == null) {
            return false;
        }
        Iterator<CDORevision> it = list.iterator();
        while (it.hasNext()) {
            CDORevision rev = it.next();
            if (rev.getVersion() != revision.getVersion()) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public synchronized CDORevision getResource(String path) {
        CDOPathFeature pathFeature = this.getRepository().getPackageManager().getCDOResourcePackage().getCDOResourceClass().getCDOPathFeature();
        for (List<CDORevision> list : this.revisions.values()) {
            String p;
            CDORevision revision;
            if (list.isEmpty() || !(revision = list.get(0)).isResource() || !ObjectUtil.equals((Object)(p = (String)revision.getData().get((CDOFeature)pathFeature, 0)), (Object)path)) continue;
            return revision;
        }
        return null;
    }

    @Override
    public boolean hasBranchingSupport() {
        return false;
    }

    @Override
    public boolean hasWriteDeltaSupport() {
        return true;
    }

    @Override
    public boolean hasAuditingSupport() {
        return true;
    }

    @Override
    public void repairAfterCrash() {
    }

    @Override
    public MEMStoreAccessor createReader(ISession session) {
        return new MEMStoreAccessor(this, session);
    }

    @Override
    public MEMStoreAccessor createWriter(IView view) {
        return new MEMStoreAccessor(this, view);
    }

    protected void doDeactivate() throws Exception {
        this.revisions.clear();
        super.doDeactivate();
    }

    private CDORevision getRevisionByVersion(List<CDORevision> list, int version) {
        for (CDORevision revision : list) {
            if (revision.getVersion() != version) continue;
            return revision;
        }
        return null;
    }
}

