/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.signal.Request;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidationNotification
extends Request {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, InvalidationNotification.class);
    private long timeStamp;
    private List<CDOIDAndVersion> dirtyIDs;

    public InvalidationNotification(IChannel channel, long timeStamp, List<CDOIDAndVersion> dirtyIDs) {
        super(channel);
        this.timeStamp = timeStamp;
        this.dirtyIDs = dirtyIDs;
    }

    protected short getSignalID() {
        return 14;
    }

    protected void requesting(ExtendedDataOutputStream out) throws IOException {
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing timeStamp: {0,date} {0,time}", new Object[]{this.timeStamp});
        }
        out.writeLong(this.timeStamp);
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing {0} dirty IDs", new Object[]{this.dirtyIDs.size()});
        }
        out.writeInt(this.dirtyIDs.size());
        for (CDOIDAndVersion dirtyID : this.dirtyIDs) {
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Writing dirty ID: {0}", new Object[]{dirtyID});
            }
            dirtyID.write((ExtendedDataOutput)out, false);
        }
    }
}

