/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.net4j.util.collection.MoveableList;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class LoadChunkIndication
extends CDOReadIndication {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, LoadChunkIndication.class);
    private CDOID id;
    private int version;
    private CDOFeature feature;
    private int fromIndex;
    private int toIndex;

    protected short getSignalID() {
        return 10;
    }

    protected void indicating(ExtendedDataInputStream in) throws IOException {
        this.id = CDOIDUtil.read((ExtendedDataInput)in, (CDOIDObjectFactory)this.getStore().getCDOIDObjectFactory());
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read revision ID: {0}", new Object[]{this.id});
        }
        this.version = in.readInt();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read revision version: {0}", new Object[]{this.version});
        }
        CDOClassRef classRef = CDOModelUtil.readClassRef((ExtendedDataInput)in);
        int featureID = in.readInt();
        CDOClass cdoClass = classRef.resolve((CDOPackageManager)this.getPackageManager());
        this.feature = cdoClass.getAllFeatures()[featureID];
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read feature: {0}", new Object[]{this.feature});
        }
        this.fromIndex = in.readInt();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read fromIndex: {0}", new Object[]{this.fromIndex});
        }
        this.toIndex = in.readInt();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read toIndex: {0}", new Object[]{this.toIndex});
        }
    }

    protected void responding(ExtendedDataOutputStream out) throws IOException {
        InternalCDORevision revision = this.getRevisionManager().getRevisionByVersion(this.id, 0, this.version);
        this.getRevisionManager().ensureChunk(revision, this.feature, this.fromIndex, this.toIndex + 1);
        Session session = this.getSession();
        MoveableList list = revision.getList(this.feature);
        int i = this.fromIndex;
        while (i <= this.toIndex) {
            CDOIDUtil.write((ExtendedDataOutput)out, (CDOID)session.provideCDOID(list.get(i)));
            ++i;
        }
    }
}

